/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.Sequence;

public class SimpleFeatureRealizer
implements FeatureRealizer,
Serializable {
    private List templateToImpl = new ArrayList();
    private FeatureRealizer fallBack;

    public SimpleFeatureRealizer() {
        this.fallBack = null;
    }

    public SimpleFeatureRealizer(FeatureRealizer fallBack) {
        this.fallBack = fallBack;
    }

    public void addImplementation(Class template, Class impl) throws BioException {
        TemplateImpl ti = new TemplateImpl(template, impl);
        this.templateToImpl.add(0, ti);
    }

    public Feature realizeFeature(Sequence seq, FeatureHolder parent, Feature.Template temp) throws BioException {
        Iterator i = this.templateToImpl.iterator();
        while (i.hasNext()) {
            TemplateImpl ti = (TemplateImpl)i.next();
            if (!ti.accept(temp)) continue;
            return ti.realize(seq, parent, temp);
        }
        if (this.fallBack != null) {
            return this.fallBack.realizeFeature(seq, parent, temp);
        }
        throw new BioException("Couldn't find realized implementation for template of class " + temp.getClass().getName());
    }

    private static class TemplateImpl {
        private Class template;
        private Constructor cons;
        static /* synthetic */ Class class$org$biojava$bio$seq$Sequence;
        static /* synthetic */ Class class$org$biojava$bio$seq$FeatureHolder;

        private TemplateImpl(Class template, Class impl) throws BioException {
            Class[] signature = new Class[]{class$org$biojava$bio$seq$Sequence == null ? (class$org$biojava$bio$seq$Sequence = TemplateImpl.class$("org.biojava.bio.seq.Sequence")) : class$org$biojava$bio$seq$Sequence, class$org$biojava$bio$seq$FeatureHolder == null ? (class$org$biojava$bio$seq$FeatureHolder = TemplateImpl.class$("org.biojava.bio.seq.FeatureHolder")) : class$org$biojava$bio$seq$FeatureHolder, template};
            this.template = template;
            try {
                this.cons = impl.getConstructor(signature);
            }
            catch (NoSuchMethodException ex) {
                throw new BioException(ex, "Class " + impl.getName() + " does not have suitable constructor");
            }
        }

        public boolean accept(Feature.Template temp) {
            return this.template.isInstance(temp);
        }

        public Feature realize(Sequence seq, FeatureHolder parent, Feature.Template temp) throws BioException {
            Object[] consArgs = new Object[]{seq, parent, temp};
            try {
                return (Feature)this.cons.newInstance(consArgs);
            }
            catch (Exception ex) {
                throw new BioException(ex, "Couldn't realize feature");
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

