/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.Symbol;

class TranscriptionTable
implements ReversibleTranslationTable {
    TranscriptionTable() {
    }

    public Symbol translate(Symbol s) throws IllegalSymbolException {
        if (s == DNATools.t()) {
            return RNATools.u();
        }
        DNATools.getDNA().validate(s);
        return s;
    }

    public Symbol untranslate(Symbol s) throws IllegalSymbolException {
        if (s == RNATools.u()) {
            return DNATools.t();
        }
        RNATools.getRNA().validate(s);
        return s;
    }

    public Alphabet getSourceAlphabet() {
        return DNATools.getDNA();
    }

    public Alphabet getTargetAlphabet() {
        return RNATools.getRNA();
    }
}

