/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractSequenceDB
implements SequenceDB {
    protected transient ChangeSupport changeSupport = null;

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.generateChangeSupport(null);
        this.changeSupport.addChangeListener(cl);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.generateChangeSupport(ct);
        this.changeSupport.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeSupport.removeChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.changeSupport.removeChangeListener(cl, ct);
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator pID;
            {
                this.pID = AbstractSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.pID.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return AbstractSequenceDB.this.getSequence((String)this.pID.next());
            }
        };
    }

    public void addSequence(Sequence seq) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSequenceDB is immutable");
    }

    public void removeSequence(String id) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSequenceDB is immutable");
    }

    public abstract Set ids();

    public abstract Sequence getSequence(String var1) throws IllegalIDException, BioException;

    public abstract String getName();
}

