/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class AssembledSymbolList
extends AbstractSymbolList {
    private int length = 0;
    private SortedMap components = new TreeMap(Location.naturalOrder);
    private List componentList = new ArrayList();
    private static final Symbol N;
    private Location lastLocation = Location.empty;

    public void setLength(int len) {
        this.length = len;
    }

    public void putComponent(Location loc, ComponentFeature f) {
        this.components.put(loc, f);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void removeComponent(Location loc) {
        this.components.remove(loc);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public SymbolList getComponentSymbols(Location loc) {
        ComponentFeature cf = (ComponentFeature)this.components.get(loc);
        return cf.getSymbols();
    }

    public Set getComponentLocationSet() {
        return this.components.keySet();
    }

    public Location locationOfPoint(int p) {
        if (this.lastLocation.contains(p)) {
            return this.lastLocation;
        }
        int first = 0;
        int last = this.componentList.size() - 1;
        while (first <= last) {
            int check = (first + last) / 2;
            Location checkL = (Location)this.componentList.get(check);
            if (checkL.contains(p)) {
                this.lastLocation = checkL;
                return checkL;
            }
            if (p < checkL.getMin()) {
                last = check - 1;
                continue;
            }
            first = check + 1;
        }
        return null;
    }

    public Location locationUpstreamOfPoint(int p) {
        int first = 0;
        int last = this.componentList.size() - 1;
        int check = 0;
        Location checkL = null;
        while (first <= last) {
            check = (first + last) / 2;
            checkL = (Location)this.componentList.get(check);
            if (checkL.contains(p)) {
                return checkL;
            }
            if (p < checkL.getMin()) {
                last = check - 1;
                continue;
            }
            first = check + 1;
        }
        try {
            if (p < checkL.getMin()) {
                return checkL;
            }
            return (Location)this.componentList.get(check + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int pos) {
        Location l = this.locationOfPoint(pos);
        if (l != null) {
            SymbolList syms = this.getComponentSymbols(l);
            return syms.symbolAt(pos - l.getMin() + 1);
        }
        return N;
    }

    public SymbolList subList(int start, int end) {
        Location l = this.locationOfPoint(start);
        if (l != null && l.contains(end)) {
            SymbolList symbols = this.getComponentSymbols(l);
            int tstart = start - l.getMin() + 1;
            int tend = end - l.getMin() + 1;
            return symbols.subList(tstart, tend);
        }
        return super.subList(start, end);
    }

    public String subStr(int start, int end) {
        if (start < 1 || end > this.length) {
            throw new IndexOutOfBoundsException("Range out of bounds: " + start + " - " + end);
        }
        StringBuffer sb = new StringBuffer();
        int pos = start;
        while (pos <= end) {
            int numNs;
            Location loc = this.locationOfPoint(pos);
            if (loc != null) {
                SymbolList sl = this.getComponentSymbols(loc);
                int slStart = Math.max(1, pos - loc.getMin() + 1);
                int slEnd = Math.min(loc.getMax() - loc.getMin() + 1, end - loc.getMin() + 1);
                sb.append(sl.subStr(slStart, slEnd));
                pos += slEnd - slStart + 1;
                continue;
            }
            loc = this.locationUpstreamOfPoint(pos);
            if (loc != null) {
                numNs = Math.min(loc.getMin(), end + 1) - pos;
                pos = loc.getMin();
            } else {
                numNs = end - pos + 1;
                pos = end + 1;
            }
            int i = 0;
            while (i < numNs) {
                sb.append(N.getToken());
                ++i;
            }
        }
        return sb.toString();
    }

    static {
        try {
            N = DNATools.getDNA().getParser("token").parseToken("n");
        }
        catch (BioException ex) {
            throw new BioError(ex);
        }
    }
}

