/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.genomic.PrimaryTranscript;
import org.biojava.bio.seq.impl.SimpleRNAFeature;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

public class SimplePrimaryTranscript
extends SimpleRNAFeature
implements PrimaryTranscript {
    public Sequence getRNA() {
        if (this.rna == null) {
            SymbolList asRNA;
            SimpleSequenceFactory sf = new SimpleSequenceFactory();
            try {
                asRNA = RNATools.transcribe(this.getSymbols());
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError(iae, "Assertion Failure: Could not view sequence as RNA");
            }
            this.rna = sf.createSequence(asRNA, this.getSequence().getURN() + "/" + this.getType() + "/" + this.getLocation(), this.getType() + "/" + this.getLocation(), Annotation.EMPTY_ANNOTATION);
        }
        return this.rna;
    }

    public SimplePrimaryTranscript(Sequence sourceSeq, FeatureHolder parent, PrimaryTranscript.Template template) throws IllegalAlphabetException {
        super(sourceSeq, parent, template);
    }
}

