/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.FeatureTableParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;

public class EmblProcessor
extends SequenceBuilderFilter {
    public static final String PROPERTY_EMBL_ACCESSIONS = "embl_accessions";
    private boolean mBadFeature = false;
    private FeatureTableParser features;
    private List accessions = new ArrayList();

    public EmblProcessor(SequenceBuilder delegate) {
        super(delegate);
        this.features = new FeatureTableParser(this, "EMBL");
    }

    public void endSequence() throws ParseException {
        if (this.accessions.size() > 0) {
            String id = (String)this.accessions.get(0);
            this.getDelegate().setName(id);
            this.getDelegate().setURI("urn:sequence/embl:" + id);
            this.getDelegate().addSequenceProperty(PROPERTY_EMBL_ACCESSIONS, this.accessions);
        }
        this.getDelegate().endSequence();
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        try {
            if (this.mBadFeature) {
                if (value != null) {
                    String featureLine = value.toString();
                    if (key.equals("FT") && featureLine.charAt(0) != ' ') {
                        this.mBadFeature = false;
                        this.features.startFeature(featureLine.substring(0, 15).trim());
                        this.features.featureData(featureLine.substring(16));
                    }
                }
            } else {
                if (this.features.inFeature() && !key.equals("FT")) {
                    this.features.endFeature();
                }
                if (key.equals("FT")) {
                    String featureLine = value.toString();
                    if (featureLine.charAt(0) != ' ') {
                        if (this.features.inFeature()) {
                            this.features.endFeature();
                        }
                        this.features.startFeature(featureLine.substring(0, 15).trim());
                    }
                    this.features.featureData(featureLine.substring(16));
                } else {
                    this.getDelegate().addSequenceProperty(key, value);
                    if (key.equals("AC")) {
                        String acc = value.toString();
                        StringTokenizer toke = new StringTokenizer(acc, "; ");
                        while (toke.hasMoreTokens()) {
                            this.accessions.add(toke.nextToken());
                        }
                    }
                }
            }
        }
        catch (BioException ex) {
            this.mBadFeature = true;
            System.err.println(ex);
        }
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new EmblProcessor(this.delegateFactory.makeSequenceBuilder());
        }
    }
}

