/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

class GenbankContext {
    private static final int HEADER = 1;
    private static final int FEATURES = 2;
    private static final int SEQUENCE = 3;
    private static final int VERSION_LENGTH = 11;
    private static final int TAG_LENGTH = 12;
    private int status = 1;
    private SymbolParser symParser;
    private StreamParser streamParser;
    private List symbols;
    private String accession;
    private String headerTag = "";
    private StringBuffer headerTagText = new StringBuffer();
    private SeqIOListener listener;

    protected GenbankContext(SymbolParser theSymbolParser, SeqIOListener theListener) {
        this.symbols = new ArrayList();
        this.listener = theListener;
        this.symParser = theSymbolParser;
        this.streamParser = this.symParser.parseStream(this.listener);
    }

    protected void processLine(String line) throws ParseException, IllegalSymbolException {
        if (line.startsWith("FEATURES")) {
            this.status = 2;
            this.saveSeqAnno();
        } else if (line.startsWith("ORIGIN")) {
            this.status = 3;
            this.saveSeqAnno();
        } else if (line.startsWith("//")) {
            this.streamParser.close();
        } else if (this.status == 2) {
            this.processFeatureLine(line);
        } else if (this.status == 3) {
            this.processSeqLine(line, this.streamParser);
        } else if (this.status == 1) {
            this.processHeaderLine(line);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processSeqLine(String line, StreamParser theParser) throws IllegalSymbolException {
        cline = line.toCharArray();
        parseStart = 0;
        parseEnd = 0;
        ** GOTO lbl15
        {
            ++parseStart;
            do {
                if (parseStart < cline.length && (cline[parseStart] == ' ' || Character.isDigit(cline[parseStart]))) continue block0;
                if (parseStart >= cline.length) break block0;
                parseEnd = parseStart + 1;
                while (parseEnd < cline.length && cline[parseEnd] != ' ') {
                    ++parseEnd;
                }
                theParser.characters(cline, parseStart, parseEnd - parseStart);
                parseStart = parseEnd;
lbl15:
                // 2 sources

            } while (parseStart < cline.length);
        }
    }

    private void processFeatureLine(String line) throws ParseException {
        if (line.startsWith("     ")) {
            this.saveSeqAnno();
            this.headerTag = "FT";
            this.headerTagText = new StringBuffer(line.substring(5));
        } else {
            this.processHeaderLine(line);
        }
    }

    private void processHeaderLine(String line) throws ParseException {
        if (line.startsWith("LOCUS")) {
            this.saveSeqAnno();
            StringTokenizer lineTokens = new StringTokenizer(line);
            this.headerTag = lineTokens.nextToken();
            this.headerTagText = new StringBuffer(lineTokens.nextToken());
            this.saveSeqAnno();
            this.headerTag = "SIZE";
            this.headerTagText = new StringBuffer(lineTokens.nextToken());
            lineTokens.nextToken();
            if (line.charAt(34) != ' ') {
                this.saveSeqAnno();
                this.headerTag = "STRANDS";
                this.headerTagText = new StringBuffer(lineTokens.nextToken());
            }
            if (line.charAt(37) != ' ') {
                this.saveSeqAnno();
                this.headerTag = "TYPE";
                this.headerTagText = new StringBuffer(lineTokens.nextToken());
            }
            if (line.charAt(43) != ' ') {
                this.saveSeqAnno();
                this.headerTag = "CIRCULAR";
                this.headerTagText = new StringBuffer(lineTokens.nextToken());
            }
            this.saveSeqAnno();
            this.headerTag = "DIVISION";
            this.headerTagText = new StringBuffer(lineTokens.nextToken());
            this.saveSeqAnno();
            this.headerTag = "MDAT";
            this.headerTagText = new StringBuffer(lineTokens.nextToken());
        } else if (line.startsWith("VERSION")) {
            String nextToken;
            this.saveSeqAnno();
            StringTokenizer lineTokens = new StringTokenizer(line);
            this.headerTag = lineTokens.nextToken();
            this.headerTagText = new StringBuffer(lineTokens.nextToken());
            if (lineTokens.hasMoreTokens() && (nextToken = lineTokens.nextToken()).startsWith("GI")) {
                this.saveSeqAnno();
                this.headerTag = "GI";
                this.headerTagText = new StringBuffer(nextToken.substring(3));
            }
        } else if (this.hasHeaderTag(line)) {
            this.saveSeqAnno();
            this.headerTag = line.substring(0, 12).trim();
            this.headerTagText = new StringBuffer(line.substring(12));
        } else {
            this.headerTagText.append(" " + line.substring(12));
        }
    }

    private void saveSeqAnno() throws ParseException {
        if (!this.headerTag.equals("")) {
            this.listener.addSequenceProperty(this.headerTag, this.headerTagText.toString());
            this.headerTag = "";
            this.headerTagText = new StringBuffer("");
        }
    }

    private boolean hasHeaderTag(String line) {
        boolean isHeaderTag = false;
        char[] l = line.toCharArray();
        int i = 0;
        while (i < 12) {
            if (l[i] != ' ') {
                isHeaderTag = true;
                break;
            }
            ++i;
        }
        return isHeaderTag;
    }
}

