/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

public class SimpleAlphabet
extends AbstractAlphabet
implements Serializable {
    private String name;
    private Annotation annotation;
    private final Set symbols = new HashSet();
    private final Map ambigMap;
    private final Set ambig = new HashSet();
    private List alphabets;

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public Iterator ambiguities() {
        return this.ambig.iterator();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    public int size() {
        return this.symbols.size();
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, new ArrayList(this.symbols));
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex, "There should be no circumstances under which this failed");
        }
    }

    protected boolean containsImpl(AtomicSymbol s) {
        return this.symbols.contains(s);
    }

    protected void addSymbolImpl(AtomicSymbol s) throws IllegalSymbolException, ChangeVetoException {
        this.symbols.add(s);
    }

    public void addAmbiguity(Symbol aSym) throws IllegalSymbolException {
        this.validate(aSym);
        if (this.ambig.contains(aSym)) {
            throw new IllegalSymbolException("Can't add " + aSym.getName() + " twice");
        }
        HashSet key = new HashSet();
        Iterator i = ((FiniteAlphabet)aSym.getMatches()).iterator();
        while (i.hasNext()) {
            key.add(i.next());
        }
        this.ambig.add(aSym);
        this.ambigMap.put(key, aSym);
    }

    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        Symbol a = (Symbol)this.ambigMap.get(syms);
        if (a == null) {
            a = super.getAmbiguity(syms);
            this.addAmbiguity(a);
        }
        return a;
    }

    public void removeSymbol(Symbol s) throws IllegalSymbolException {
        this.validate(s);
        if (s instanceof AtomicSymbol) {
            this.symbols.remove(s);
        } else {
            FiniteAlphabet sa = (FiniteAlphabet)s.getMatches();
            Iterator i = sa.iterator();
            while (i.hasNext()) {
                Symbol sym = (Symbol)i.next();
                this.symbols.remove(sym);
            }
        }
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public AtomicSymbol getSymbolImpl(List symL) throws IllegalSymbolException {
        AtomicSymbol s = (AtomicSymbol)symL.get(0);
        return s;
    }

    public SimpleAlphabet() {
        this(new HashSet(), null);
    }

    public SimpleAlphabet(Set symbols) {
        this(symbols, null);
    }

    public SimpleAlphabet(String name) {
        this(new HashSet(), name);
    }

    public SimpleAlphabet(Set symbols, String name) {
        this.ambigMap = new HashMap();
        this.name = name;
        this.alphabets = null;
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            AtomicSymbol a = (AtomicSymbol)i.next();
            this.symbols.add(a);
        }
    }
}

