/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.HashMap;
import java.util.Map;
import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.SVMKernel;

public class CachingKernel
extends NestedKernel {
    private transient Map cache;

    public CachingKernel() {
    }

    public CachingKernel(SVMKernel k) {
        super(k);
    }

    public void setNestedKernel(SVMKernel k) {
        super.setNestedKernel(k);
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        this.cache.clear();
    }

    public double evaluate(Object x, Object y) {
        ObjectPair op = new ObjectPair(x, y);
        Double d = null;
        Map map = this.cache;
        synchronized (map) {
            d = (Double)this.cache.get(op);
        }
        if (d == null) {
            d = new Double(this.getNestedKernel().evaluate(x, y));
            Map map2 = this.cache;
            synchronized (map2) {
                this.cache.put(op, d);
            }
        }
        return d;
    }

    public String toString() {
        return this.getNestedKernel().toString();
    }

    private static class ObjectPair {
        Object a;
        Object b;

        public ObjectPair(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object x) {
            if (!(x instanceof ObjectPair)) {
                return false;
            }
            ObjectPair op = (ObjectPair)x;
            return op.a == this.a && op.b == this.b || op.a == this.b && op.b == this.a;
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }
    }
}

