/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import org.biojava.utils.query.Filter;
import org.biojava.utils.query.JavaType;
import org.biojava.utils.query.Operation;
import org.biojava.utils.query.OperationException;
import org.biojava.utils.query.QueryTools;
import org.biojava.utils.query.Queryable;
import org.biojava.utils.query.Type;

public abstract class Follow
implements Operation {
    public Queryable apply(Queryable items) throws OperationException {
        Queryable result = new Queryable.Empty(this.getOutputType());
        Iterator i = items.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            Queryable fo = this.follow(o);
            result = QueryTools.union(result, fo);
        }
        return result;
    }

    public boolean isSubsetOf(Operation op) {
        return op instanceof Filter.RejectAll || op.equals(this);
    }

    public boolean isDisjoint(Operation op) {
        return false;
    }

    public abstract Queryable follow(Object var1) throws OperationException;

    public abstract Type getOutputType();

    public abstract Type getInputType();

    public static final class FollowField
    extends Follow {
        private final Field field;

        public FollowField(Field field) {
            this.field = field;
        }

        public Queryable follow(Object item) throws OperationException {
            try {
                return QueryTools.createSingleton(this.field.get(item));
            }
            catch (IllegalAccessException iae) {
                throw new OperationException(iae, "Couldn't access field");
            }
        }

        public Type getInputType() {
            return JavaType.getType(this.field.getDeclaringClass());
        }

        public Type getOutputType() {
            return JavaType.getType(this.field.getType());
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FollowField) {
                FollowField ff = (FollowField)o;
                return this.field.equals(ff.field);
            }
            return false;
        }

        public String toString() {
            return "Follow.FollowField[" + this.field + "]";
        }
    }

    public static final class FollowMethod
    extends Follow {
        public static final Object[] EMPTY_ARGS = new Object[0];
        public static final Class[] EMPTY_CLASSES = new Class[0];
        private final Method method;

        public FollowMethod(Method method) {
            if (method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Method must be no-args");
            }
            this.method = method;
        }

        public Queryable follow(Object item) throws OperationException {
            try {
                return QueryTools.createSingleton(this.method.invoke(item, EMPTY_ARGS));
            }
            catch (InvocationTargetException ite) {
                throw new OperationException(ite, "Couldn't invoke method");
            }
            catch (IllegalAccessException iae) {
                throw new OperationException(iae, "Couldn't access method");
            }
        }

        public Type getInputType() {
            return JavaType.getType(this.method.getDeclaringClass());
        }

        public Type getOutputType() {
            return JavaType.getType(this.method.getReturnType());
        }
    }

    public static final class FollowCollectionToMembers
    extends Follow {
        private final Type outputType;
        static /* synthetic */ Class class$java$util$Set;

        public FollowCollectionToMembers(Type outputType) {
            this.outputType = outputType;
        }

        public Queryable follow(Object item) {
            Set si = (Set)item;
            return QueryTools.createQueryable(si, this.getOutputType());
        }

        public Type getInputType() {
            return JavaType.getType(class$java$util$Set == null ? (class$java$util$Set = FollowCollectionToMembers.class$("java.util.Set")) : class$java$util$Set);
        }

        public Type getOutputType() {
            return this.outputType;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

