/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.NestedError;
import org.biojava.utils.NestedException;
import org.biojava.utils.query.Arc;
import org.biojava.utils.query.Filter;
import org.biojava.utils.query.FilterByQuery;
import org.biojava.utils.query.FilterSet;
import org.biojava.utils.query.Follow;
import org.biojava.utils.query.FollowQuery;
import org.biojava.utils.query.JavaType;
import org.biojava.utils.query.Node;
import org.biojava.utils.query.Operation;
import org.biojava.utils.query.OperationException;
import org.biojava.utils.query.Query;
import org.biojava.utils.query.QueryBuilder;
import org.biojava.utils.query.QueryHolder;
import org.biojava.utils.query.Queryable;
import org.biojava.utils.query.SimpleNode;
import org.biojava.utils.query.SimpleQueryable;
import org.biojava.utils.query.SimpleTuple;
import org.biojava.utils.query.Tuple;
import org.biojava.utils.query.Type;
import org.biojava.utils.query.TypeCastException;

public class QueryTools {
    static Map cacheMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$biojava$utils$query$Query;
    static /* synthetic */ Class class$org$biojava$utils$query$Node;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$org$biojava$utils$query$Arc;
    static /* synthetic */ Class class$org$biojava$utils$query$Operation;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$biojava$utils$query$Filter;
    static /* synthetic */ Class class$java$lang$String;

    public static Queryable union(Queryable a, Queryable b) throws TypeCastException {
        Type type = QueryTools.guessType(a.getItemType(), b.getItemType());
        if (a instanceof Queryable.Empty) {
            return b;
        }
        if (b instanceof Queryable.Empty) {
            return a;
        }
        HashSet result = new HashSet();
        QueryTools.addAll(result, a);
        QueryTools.addAll(result, b);
        return new SimpleQueryable(result, type);
    }

    private static void addAll(Set result, Queryable items) {
        if (items instanceof Queryable.Singleton) {
            result.add(((Queryable.Singleton)items).getItem());
        } else if (items instanceof SimpleQueryable) {
            result.addAll(((SimpleQueryable)items).items);
        } else {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
    }

    public static Queryable intersection(Queryable a, Queryable b) {
        Type type = QueryTools.guessType(a.getItemType(), b.getItemType());
        if (a instanceof Queryable.Empty || b instanceof Queryable.Empty) {
            return new Queryable.Empty(type);
        }
        if (b instanceof Queryable.Singleton) {
            Queryable q = b;
            b = a;
            a = q;
        }
        if (a instanceof Queryable.Singleton) {
            Object item = ((Queryable.Singleton)a).getItem();
            if (b.contains(item)) {
                return a;
            }
            return new Queryable.Empty(type);
        }
        HashSet result = new HashSet();
        if (b.size() < a.size()) {
            Queryable q = b;
            b = a;
            a = q;
        }
        Iterator i = a.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (!a.contains(item) || !b.contains(item)) continue;
            result.add(item);
        }
        return new SimpleQueryable(result, type);
    }

    public static Queryable subtraction(Queryable a, Queryable b) {
        if (a instanceof Queryable.Empty) {
            return a;
        }
        if (a instanceof Queryable.Singleton) {
            if (b.contains(((Queryable.Singleton)a).getItem())) {
                return new Queryable.Empty(a.getItemType());
            }
            return a;
        }
        if (b instanceof Queryable.Empty) {
            return a;
        }
        HashSet result = new HashSet();
        Iterator i = a.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (b.contains(o)) continue;
            result.add(o);
        }
        return QueryTools.createQueryable(result, a.getItemType());
    }

    public static Type guessType(Type a, Type b) {
        Type type = a.isAssignableFrom(b) ? b : (b.isAssignableFrom(a) ? a : JavaType.getType(class$java$lang$Object == null ? (class$java$lang$Object = QueryTools.class$("java.lang.Object")) : class$java$lang$Object));
        return type;
    }

    public static Queryable createQueryable(Set items, Type type) {
        if (items.size() == 0) {
            return new Queryable.Empty(type);
        }
        if (items.size() == 1) {
            return new Queryable.Singleton(items.iterator().next());
        }
        return new SimpleQueryable(items, type);
    }

    public static Queryable createSingleton(Object item) {
        return new Queryable.Singleton(item);
    }

    public static Queryable select(Query query, Node startNode, Node endNode, Queryable items) throws OperationException {
        return QueryTools.select(query, startNode, endNode, items, cacheMap);
    }

    private static Queryable select(Query query, Node startNode, Node endNode, Queryable items, Map cache) throws OperationException {
        boolean debug = false;
        ArrayList<Object> frame = new ArrayList<Object>();
        frame.add(query);
        frame.add(startNode);
        frame.add(endNode);
        frame.add(items);
        if (cache.containsKey(frame)) {
            Object val = cache.get(frame);
            if (val instanceof Queryable) {
                return (Queryable)val;
            }
            return new Queryable.Empty(items.getItemType());
        }
        cache.put(frame, frame);
        if (items.size() == 0) {
            return items;
        }
        Queryable selected = startNode == endNode ? items : new Queryable.Empty(items.getItemType());
        Iterator ai = query.getArcsFrom(startNode).iterator();
        while (ai.hasNext()) {
            Arc arc = (Arc)ai.next();
            Iterator oi = query.getOperations(arc).iterator();
            while (oi.hasNext()) {
                Queryable res;
                Operation op = (Operation)oi.next();
                try {
                    res = op.apply(items);
                }
                catch (OperationException oe) {
                    throw new OperationException(oe, "Failed to execute " + arc + " " + op);
                }
                catch (ClassCastException cce) {
                    throw new OperationException(cce, "Failed to execute " + arc + " " + op);
                }
                catch (IllegalArgumentException iae) {
                    throw new OperationException(iae, "Failed to execute " + arc + " " + op);
                }
                catch (TypeCastException tce) {
                    throw new OperationException(tce, "Failed to execute " + arc + " " + op);
                }
                if (res.size() == 0) continue;
                selected = QueryTools.union(selected, QueryTools.select(query, arc.to, endNode, res, cache));
            }
        }
        cache.put(frame, selected);
        return selected;
    }

    public static Query optimize(Query query, Node startNode, Node endNode) throws OperationException {
        Query findMergableFiltersQuery;
        SimpleNode findMergableFiltersEnd;
        SimpleNode findMergableFiltersStart;
        Queryable nodesInPath = QueryTools.pruneQuery(query, startNode, endNode);
        QueryBuilder pruneQB = new QueryBuilder();
        pruneQB.addQuery(query);
        Iterator i = query.getNodes().iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (nodesInPath.contains(n)) continue;
            System.out.println("Removing " + n);
            pruneQB.removeNode(n);
        }
        query = pruneQB.buildQuery();
        try {
            Method Collection_size;
            Method Query_getNodes;
            Method Query_getOperations;
            Method Query_getArcsTo;
            Method Query_getArcsFrom;
            Tuple.TypeList TypeList_queryNode = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node});
            Tuple.TypeList TypeList_queryQueryNode = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node});
            Tuple.TypeList TypeList_querySet = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set});
            Tuple.TypeList TypeList_queryArc = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Arc == null ? (class$org$biojava$utils$query$Arc = QueryTools.class$("org.biojava.utils.query.Arc")) : class$org$biojava$utils$query$Arc});
            Tuple.TypeList TypeList_queryOperation = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Operation == null ? (class$org$biojava$utils$query$Operation = QueryTools.class$("org.biojava.utils.query.Operation")) : class$org$biojava$utils$query$Operation});
            Tuple.TypeList TypeList_queryQuerySet = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set});
            Tuple.Permutate doubleQueryNode = new Tuple.Permutate(new int[]{0, 0, 1}, TypeList_queryNode);
            try {
                Query_getArcsFrom = (class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query).getMethod("getArcsFrom", class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node);
                Query_getArcsTo = (class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query).getMethod("getArcsTo", class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node);
                Query_getOperations = (class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query).getMethod("getOperations", class$org$biojava$utils$query$Arc == null ? (class$org$biojava$utils$query$Arc = QueryTools.class$("org.biojava.utils.query.Arc")) : class$org$biojava$utils$query$Arc);
                Query_getNodes = (class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query).getMethod("getNodes", Follow.FollowMethod.EMPTY_CLASSES);
                Collection_size = (class$java$util$Collection == null ? (class$java$util$Collection = QueryTools.class$("java.util.Collection")) : class$java$util$Collection).getMethod("size", Follow.FollowMethod.EMPTY_CLASSES);
            }
            catch (NoSuchMethodException nsme) {
                throw new NestedError(nsme);
            }
            QueryBuilder sqb = new QueryBuilder();
            SimpleNode collectionSizeIs1Start = new SimpleNode("sizeCheckStart", JavaType.getType(class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set));
            SimpleNode setSize = new SimpleNode("setSize", JavaType.getType(class$java$lang$Integer == null ? (class$java$lang$Integer = QueryTools.class$("java.lang.Integer")) : class$java$lang$Integer));
            SimpleNode collectionSizeIs1End = new SimpleNode("sizeIs1", JavaType.getType(class$java$lang$Integer == null ? (class$java$lang$Integer = QueryTools.class$("java.lang.Integer")) : class$java$lang$Integer));
            sqb.addArc(new Arc(collectionSizeIs1Start, setSize), new Follow.FollowMethod(Collection_size));
            sqb.addArc(new Arc(setSize, collectionSizeIs1End), new Filter.Equals(new Integer(1), JavaType.getType(class$java$lang$Integer == null ? (class$java$lang$Integer = QueryTools.class$("java.lang.Integer")) : class$java$lang$Integer)));
            Query collectionSizeIs1Query = sqb.buildQuery();
            QueryBuilder arcsQB = new QueryBuilder();
            SimpleNode arcsFromStart = new SimpleNode("arcs from start (query,node)", TypeList_queryNode);
            SimpleNode arcsFromQueryQueryNode = new SimpleNode("from prepared (query,query,node)", TypeList_queryQueryNode);
            SimpleNode arcsToStart = new SimpleNode("arcs to start (query,node)", TypeList_queryNode);
            SimpleNode arcsToQueryQueryNode = new SimpleNode("to prepared (query,query,node)", TypeList_queryQueryNode);
            SimpleNode queryArcs = new SimpleNode("query,{arc}", TypeList_querySet);
            SimpleNode queryArcs1 = new SimpleNode("query,{arc} size is 1", TypeList_querySet);
            SimpleNode queryArc = new SimpleNode("query,arc", TypeList_queryArc);
            SimpleNode opSet = new SimpleNode("operator set", JavaType.getType(class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set));
            SimpleNode opSet1 = new SimpleNode("size is 1", JavaType.getType(class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set));
            SimpleNode ops = new SimpleNode("operator", JavaType.getType(class$org$biojava$utils$query$Operation == null ? (class$org$biojava$utils$query$Operation = QueryTools.class$("org.biojava.utils.query.Operation")) : class$org$biojava$utils$query$Operation));
            SimpleNode filterOps = new SimpleNode("filter op", JavaType.getType(class$org$biojava$utils$query$Filter == null ? (class$org$biojava$utils$query$Filter = QueryTools.class$("org.biojava.utils.query.Filter")) : class$org$biojava$utils$query$Filter));
            arcsQB.addArc(new Arc(arcsFromStart, arcsFromQueryQueryNode), doubleQueryNode);
            arcsQB.addArc(new Arc(arcsFromQueryQueryNode, queryArcs), new Tuple.FollowMethod(Query_getArcsFrom, TypeList_queryQueryNode));
            arcsQB.addArc(new Arc(arcsToStart, arcsToQueryQueryNode), doubleQueryNode);
            arcsQB.addArc(new Arc(arcsToQueryQueryNode, queryArcs), new Tuple.FollowMethod(Query_getArcsTo, TypeList_queryQueryNode));
            arcsQB.addArc(new Arc(queryArcs, queryArcs1), new Tuple.FilterByIndex(new FilterByQuery(collectionSizeIs1Query, collectionSizeIs1Start, collectionSizeIs1End, Filter.CompareInteger.EQ, 1), 1, TypeList_querySet));
            arcsQB.addArc(new Arc(queryArcs1, queryArc), new Tuple.FollowTupleTo(1, new Follow.FollowCollectionToMembers(JavaType.getType(class$org$biojava$utils$query$Arc == null ? (class$org$biojava$utils$query$Arc = QueryTools.class$("org.biojava.utils.query.Arc")) : class$org$biojava$utils$query$Arc)), TypeList_queryOperation));
            arcsQB.addArc(new Arc(queryArc, opSet), new Tuple.FollowMethod(Query_getOperations, TypeList_queryArc));
            arcsQB.addArc(new Arc(opSet, opSet1), new FilterByQuery(collectionSizeIs1Query, collectionSizeIs1Start, collectionSizeIs1End, Filter.CompareInteger.EQ, 1));
            arcsQB.addArc(new Arc(opSet1, ops), new Follow.FollowCollectionToMembers(JavaType.getType(class$org$biojava$utils$query$Operation == null ? (class$org$biojava$utils$query$Operation = QueryTools.class$("org.biojava.utils.query.Operation")) : class$org$biojava$utils$query$Operation)));
            arcsQB.addArc(new Arc(ops, filterOps), new Filter.ByType(JavaType.getType(class$org$biojava$utils$query$Operation == null ? (class$org$biojava$utils$query$Operation = QueryTools.class$("org.biojava.utils.query.Operation")) : class$org$biojava$utils$query$Operation), JavaType.getType(class$org$biojava$utils$query$Filter == null ? (class$org$biojava$utils$query$Filter = QueryTools.class$("org.biojava.utils.query.Filter")) : class$org$biojava$utils$query$Filter)));
            Query arcsQuery = arcsQB.buildQuery();
            QueryBuilder fmfqb = new QueryBuilder();
            findMergableFiltersStart = new SimpleNode("start", JavaType.getType(class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query));
            SimpleNode qns = new SimpleNode("query,{node}", TypeList_querySet);
            SimpleNode qn = new SimpleNode("query,node", TypeList_queryNode);
            SimpleNode notStart = new SimpleNode("not start node", TypeList_queryNode);
            SimpleNode notEnd = new SimpleNode("not end node", TypeList_queryNode);
            SimpleNode oneFrom = new SimpleNode("oneFrom", TypeList_queryNode);
            SimpleNode oneTo = new SimpleNode("oneTo", TypeList_queryNode);
            findMergableFiltersEnd = new SimpleNode("nodes", JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node));
            fmfqb.addArc(new Arc(findMergableFiltersStart, qns), new Tuple.FollowToTuple(new Follow.FollowMethod(Query_getNodes)));
            fmfqb.addArc(new Arc(qns, qn), new Tuple.FollowTupleTo(1, new Follow.FollowCollectionToMembers(JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node)), TypeList_querySet));
            fmfqb.addArc(new Arc(qn, notStart), new Tuple.FilterByIndex(new Filter.Not(new Filter.Equals(startNode, JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node))), 1, TypeList_queryNode));
            fmfqb.addArc(new Arc(notStart, notEnd), new Tuple.FilterByIndex(new Filter.Not(new Filter.Equals(endNode, JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node))), 1, TypeList_queryNode));
            fmfqb.addArc(new Arc(notEnd, oneFrom), new FilterByQuery(arcsQuery, arcsFromStart, filterOps, Filter.CompareInteger.EQ, 1));
            fmfqb.addArc(new Arc(oneFrom, oneTo), new FilterByQuery(arcsQuery, arcsToStart, filterOps, Filter.CompareInteger.EQ, 1));
            fmfqb.addArc(new Arc(oneTo, findMergableFiltersEnd), new Tuple.FollowObject(TypeList_queryNode, 1));
            findMergableFiltersQuery = fmfqb.buildQuery();
        }
        catch (OperationException oe) {
            throw new NestedError(oe, "Can't initialize optimization queries");
        }
        Queryable mergableNodes = QueryTools.select(findMergableFiltersQuery, findMergableFiltersStart, findMergableFiltersEnd, QueryTools.createSingleton(query));
        if (mergableNodes.size() == 0) {
            return query;
        }
        QueryBuilder qb = new QueryBuilder();
        qb.addQuery(query);
        while (mergableNodes.size() > 0) {
            Operation op;
            Arc arc;
            Node node;
            HashSet<Operation> chainOps = new HashSet<Operation>();
            HashSet<Node> visitedNodes = new HashSet<Node>();
            Node from = node = (Node)mergableNodes.iterator().next();
            Node to = node;
            System.out.println("Optimizing from " + node);
            do {
                arc = (Arc)query.getArcsFrom(to).iterator().next();
                op = (Operation)query.getOperations(arc).iterator().next();
                chainOps.add(op);
                visitedNodes.add(to);
                to = arc.to;
                System.out.println("walked to " + to + " by following arc " + arc);
            } while (to != node && mergableNodes.contains(to));
            do {
                arc = (Arc)query.getArcsTo(from).iterator().next();
                op = (Operation)query.getOperations(arc).iterator().next();
                chainOps.add(op);
                visitedNodes.add(from);
                from = arc.from;
                System.out.println("walked to " + from + " by following arc " + arc);
            } while (from != node && mergableNodes.contains(from));
            Iterator ni = visitedNodes.iterator();
            while (ni.hasNext()) {
                Node n = (Node)ni.next();
                qb.removeNode(n);
            }
            mergableNodes = QueryTools.subtraction(mergableNodes, QueryTools.createQueryable(visitedNodes, mergableNodes.getItemType()));
            qb.addArc(new Arc(from, to), new FilterSet(chainOps));
        }
        return qb.buildQuery();
    }

    public static Queryable findNodeByLabel(Query query, String label) {
        try {
            Method Node_getLabel;
            Method Query_getNodes;
            try {
                Query_getNodes = (class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query).getMethod("getNodes", Follow.FollowMethod.EMPTY_CLASSES);
                Node_getLabel = (class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node).getMethod("getLabel", Follow.FollowMethod.EMPTY_CLASSES);
            }
            catch (NoSuchMethodException nsme) {
                throw new NestedError(nsme);
            }
            QueryBuilder nlqb = new QueryBuilder();
            SimpleNode nodeLabelQueryStart = new SimpleNode("start", JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node));
            SimpleNode labelNode = new SimpleNode("label", JavaType.getType(class$java$lang$String == null ? (class$java$lang$String = QueryTools.class$("java.lang.String")) : class$java$lang$String));
            SimpleNode nodeLabelQueryEnd = new SimpleNode("end", JavaType.getType(class$java$lang$String == null ? (class$java$lang$String = QueryTools.class$("java.lang.String")) : class$java$lang$String));
            nlqb.addArc(new Arc(nodeLabelQueryStart, labelNode), new Follow.FollowMethod(Node_getLabel));
            nlqb.addArc(new Arc(labelNode, nodeLabelQueryEnd), new Filter.Equals(label, JavaType.getType(class$java$lang$String == null ? (class$java$lang$String = QueryTools.class$("java.lang.String")) : class$java$lang$String)));
            Query nodeLabelQuery = nlqb.buildQuery();
            QueryBuilder findNodeQB = new QueryBuilder();
            SimpleNode start = new SimpleNode("start", JavaType.getType(class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query));
            SimpleNode nodeSet = new SimpleNode("nodeSet", JavaType.getType(class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set));
            SimpleNode node = new SimpleNode("node", JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node));
            SimpleNode end = new SimpleNode("end", JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node));
            findNodeQB.addArc(new Arc(start, nodeSet), new Follow.FollowMethod(Query_getNodes));
            findNodeQB.addArc(new Arc(nodeSet, node), new Follow.FollowCollectionToMembers(JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node)));
            findNodeQB.addArc(new Arc(node, end), new FilterByQuery(nodeLabelQuery, nodeLabelQueryStart, nodeLabelQueryEnd, Filter.CompareInteger.EQ, 1));
            Query findNodeByLabelQuery = findNodeQB.buildQuery();
            return QueryTools.select(findNodeByLabelQuery, start, end, QueryTools.createSingleton(query));
        }
        catch (OperationException oe) {
            throw new NestedError("This should never fail");
        }
    }

    private static Queryable pruneQuery(Query query, Node queryStart, Node queryEnd) throws OperationException {
        Field Arc_to;
        Method Query_getArcsFrom;
        try {
            Query_getArcsFrom = (class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query).getMethod("getArcsFrom", class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node);
            Arc_to = (class$org$biojava$utils$query$Arc == null ? (class$org$biojava$utils$query$Arc = QueryTools.class$("org.biojava.utils.query.Arc")) : class$org$biojava$utils$query$Arc).getField("to");
        }
        catch (NoSuchMethodException nsme) {
            throw new NestedError(nsme);
        }
        catch (NoSuchFieldException nsfe) {
            throw new NestedError(nsfe);
        }
        Tuple.TypeList TypeList_queryNode = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node});
        Tuple.TypeList TypeList_queryQueryNode = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node});
        Tuple.TypeList TypeList_querySet = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$java$util$Set == null ? (class$java$util$Set = QueryTools.class$("java.util.Set")) : class$java$util$Set});
        Tuple.TypeList TypeList_queryArc = (Tuple.TypeList)JavaType.getType(new Class[]{class$org$biojava$utils$query$Query == null ? (class$org$biojava$utils$query$Query = QueryTools.class$("org.biojava.utils.query.Query")) : class$org$biojava$utils$query$Query, class$org$biojava$utils$query$Arc == null ? (class$org$biojava$utils$query$Arc = QueryTools.class$("org.biojava.utils.query.Arc")) : class$org$biojava$utils$query$Arc});
        QueryBuilder pruneQB = new QueryBuilder();
        QueryHolder pruneHolder = new QueryHolder();
        Filter.AcceptAll acceptAllTuples = new Filter.AcceptAll(TypeList_queryNode);
        SimpleNode pruneStart = new SimpleNode("start", TypeList_queryNode);
        SimpleNode accepted = new SimpleNode("accepted", TypeList_queryNode);
        SimpleNode inPath = new SimpleNode("inPath", TypeList_queryNode);
        SimpleNode pruneEnd = new SimpleNode("end", JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node));
        SimpleNode pruneInput = new SimpleNode("pruneInput", TypeList_queryNode);
        SimpleNode arcForNodeInput = new SimpleNode("arcForNodeInput", TypeList_queryQueryNode);
        SimpleNode queryArcs = new SimpleNode("queryArcs", TypeList_querySet);
        SimpleNode queryArc = new SimpleNode("queryArc", TypeList_queryArc);
        pruneQB.addArc(new Arc(pruneStart, accepted), new Tuple.FilterByIndex(new Filter.Equals(queryEnd, JavaType.getType(class$org$biojava$utils$query$Node == null ? (class$org$biojava$utils$query$Node = QueryTools.class$("org.biojava.utils.query.Node")) : class$org$biojava$utils$query$Node)), 1, TypeList_queryNode));
        pruneQB.addArc(new Arc(pruneStart, inPath), new FilterByQuery(pruneHolder, pruneInput, accepted, Filter.CompareInteger.GT, 0));
        pruneQB.addArc(new Arc(inPath, accepted), acceptAllTuples);
        pruneQB.addArc(new Arc(inPath, accepted), new FollowQuery(pruneHolder, pruneInput, accepted));
        pruneQB.addArc(new Arc(accepted, pruneEnd), new Tuple.FollowObject(TypeList_queryNode, 1));
        Query pruneQuery = pruneQB.buildQuery();
        pruneQB.addArc(new Arc(pruneInput, arcForNodeInput), new Tuple.Permutate(new int[]{0, 0, 1}, TypeList_queryNode));
        pruneQB.addArc(new Arc(arcForNodeInput, queryArcs), new Tuple.FollowMethod(Query_getArcsFrom, TypeList_queryQueryNode));
        pruneQB.addArc(new Arc(queryArcs, queryArc), new Tuple.FollowTupleTo(1, new Follow.FollowCollectionToMembers(JavaType.getType(class$org$biojava$utils$query$Arc == null ? (class$org$biojava$utils$query$Arc = QueryTools.class$("org.biojava.utils.query.Arc")) : class$org$biojava$utils$query$Arc)), TypeList_queryArc));
        pruneQB.addArc(new Arc(queryArc, pruneStart), new Tuple.FollowTupleTo(1, new Follow.FollowField(Arc_to), TypeList_queryArc));
        pruneQuery = pruneQB.buildQuery();
        try {
            pruneHolder.setQuery(pruneQuery);
        }
        catch (NestedException ne) {
            throw new NestedError(ne, "Something is badly wrong");
        }
        SimpleTuple startTup = new SimpleTuple(new Object[]{query, queryStart}, TypeList_queryNode);
        return QueryTools.select(pruneQuery, pruneStart, pruneEnd, QueryTools.createSingleton(startTup));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

