/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import org.biojava.utils.query.Tuple;
import org.biojava.utils.query.Type;

public class SimpleTuple
implements Tuple {
    private final Object[] items;
    private final Tuple.TypeList typeList;

    public SimpleTuple(Object[] items, Tuple.TypeList typeList) {
        if (items.length != typeList.size()) {
            throw new IllegalArgumentException("Items and typeList must be the same length: " + items.length + ":" + typeList.size());
        }
        int i = 0;
        while (i < items.length) {
            if (!typeList.getType(i).isInstance(items[i])) {
                throw new IllegalArgumentException("Item " + i + " is not of type " + typeList.getType(i) + " but " + items[i].getClass());
            }
            ++i;
        }
        this.items = items;
        this.typeList = typeList;
    }

    public Object getObject(int indx) {
        try {
            return this.items[indx];
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new IndexOutOfBoundsException("Can't access index " + indx + ":" + this.items.length);
        }
    }

    public Tuple.TypeList getTypeList() {
        return this.typeList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(");
        sb.append(this.getObject(0).toString());
        int i = 1;
        while (i < this.getTypeList().size()) {
            sb.append(",");
            sb.append(this.getObject(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        int hc = this.getObject(0).hashCode();
        int i = 1;
        while (i < this.getTypeList().size()) {
            hc ^= this.getObject(i).hashCode();
            ++i;
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (o instanceof Tuple) {
            Tuple tup = (Tuple)o;
            if (!this.getTypeList().equals(tup.getTypeList())) {
                return false;
            }
            int i = 0;
            while (i < this.getTypeList().size()) {
                if (this.getObject(i).equals(tup.getObject(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final class TypeList
    extends Tuple.TypeList {
        private final Type[] types;

        public TypeList(Type[] types) {
            this.types = types;
        }

        public Type getType(int indx) {
            return this.types[indx];
        }

        public int size() {
            return this.types.length;
        }
    }
}

