/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleAnnotation
implements Annotation,
Serializable {
    protected transient ChangeSupport changeSupport = null;
    private Map properties;

    protected final Map getProperties() {
        if (!this.propertiesAllocated()) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    protected final boolean propertiesAllocated() {
        return this.properties != null;
    }

    public Object getProperty(Object key) throws NoSuchElementException {
        Map prop;
        if (this.propertiesAllocated() && (prop = this.getProperties()).containsKey(key)) {
            return prop.get(key);
        }
        throw new NoSuchElementException("Property " + key + " unknown");
    }

    public void setProperty(Object key, Object value) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.getProperties().put(key, value);
        } else {
            Map properties = this.getProperties();
            ChangeEvent ce = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{key, value}, new Object[]{key, properties.get(key)});
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(ce);
                properties.put(key, value);
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public boolean containsProperty(Object key) {
        if (this.propertiesAllocated()) {
            return this.properties.containsKey(key);
        }
        return false;
    }

    public Set keys() {
        if (this.propertiesAllocated()) {
            return this.properties.keySet();
        }
        return Collections.EMPTY_SET;
    }

    public String toString() {
        Object key;
        StringBuffer sb = new StringBuffer("{");
        Map prop = this.getProperties();
        Iterator i = prop.keySet().iterator();
        if (i.hasNext()) {
            key = i.next();
            sb.append(key + "=" + prop.get(key));
        }
        while (i.hasNext()) {
            key = i.next();
            sb.append("," + key + "=" + prop.get(key));
        }
        sb.append("}");
        return sb.toString();
    }

    public Map asMap() {
        return new HashMap(this.getProperties());
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }

    public SimpleAnnotation() {
    }

    public SimpleAnnotation(Annotation ann) throws IllegalArgumentException {
        if (ann == null) {
            throw new IllegalArgumentException("Null annotation not allowed. Use Annotation.EMPTY_ANNOTATION instead.");
        }
        if (ann == Annotation.EMPTY_ANNOTATION) {
            return;
        }
        Map properties = this.getProperties();
        Iterator i = ann.keys().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            try {
                properties.put(key, ann.getProperty(key));
            }
            catch (IllegalArgumentException iae) {
                throw new BioError(iae, "Property was there and then disappeared: " + key);
            }
        }
    }

    public SimpleAnnotation(Map annMap) {
        if (annMap == null) {
            throw new IllegalArgumentException("Null annotation Map not allowed. Use an empy map instead.");
        }
        if (annMap.isEmpty()) {
            return;
        }
        Map properties = this.getProperties();
        Iterator i = annMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            properties.put(key, annMap.get(key));
        }
    }
}

