/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import org.biojava.bio.BioError;
import org.biojava.bio.dist.Count;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class IndexedCount
implements Count {
    private final AlphabetIndex indexer;
    private final double[] counts;
    protected transient ChangeSupport changeSupport = null;

    protected void createChangeSupport(ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.createChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.createChangeSupport(ct);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.createChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.removeChangeListener(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.createChangeSupport(ct);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.removeChangeListener(cl, ct);
        }
    }

    public Alphabet getAlphabet() {
        return this.indexer.getAlphabet();
    }

    public double getCount(AtomicSymbol s) throws IllegalSymbolException {
        return this.counts[this.indexer.indexForSymbol(s)];
    }

    public void setCount(AtomicSymbol s, double c) throws IllegalSymbolException, ChangeVetoException {
        if (this.changeSupport == null) {
            this.counts[this.indexer.indexForSymbol((Symbol)s)] = c;
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                int index = this.indexer.indexForSymbol(s);
                ChangeEvent ce = new ChangeEvent(this, Count.COUNTS, new Object[]{s, new Double(this.counts[index])}, new Object[]{s, new Double(c)});
                this.changeSupport.firePreChangeEvent(ce);
                this.counts[index] = c;
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public void increaseCount(AtomicSymbol s, double c) throws IllegalSymbolException, ChangeVetoException {
        if (this.changeSupport == null) {
            int n = this.indexer.indexForSymbol(s);
            this.counts[n] = this.counts[n] + c;
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                int index = this.indexer.indexForSymbol(s);
                double oc = this.counts[index];
                double nc = oc + c;
                ChangeEvent ce = new ChangeEvent(this, Count.COUNTS, new Object[]{s, new Double(oc)}, new Object[]{s, new Double(nc)});
                this.changeSupport.firePreChangeEvent(ce);
                this.counts[index] = nc;
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public void setCounts(Count c) throws IllegalAlphabetException, ChangeVetoException {
        block9: {
            if (c.getAlphabet() != this.getAlphabet()) {
                throw new IllegalAlphabetException("Alphabet must match: " + c.getAlphabet().getName() + " != " + c.getAlphabet().getName());
            }
            try {
                if (this.changeSupport == null) {
                    int i = 0;
                    while (i < this.counts.length) {
                        this.counts[i] = c.getCount((AtomicSymbol)this.indexer.symbolForIndex(i));
                        ++i;
                    }
                    break block9;
                }
                ChangeSupport i = this.changeSupport;
                synchronized (i) {
                    ChangeEvent ce = new ChangeEvent(this, Count.COUNTS);
                    this.changeSupport.firePreChangeEvent(ce);
                    int i2 = 0;
                    while (i2 < this.counts.length) {
                        this.counts[i2] = c.getCount((AtomicSymbol)this.indexer.symbolForIndex(i2));
                        ++i2;
                    }
                    this.changeSupport.firePostChangeEvent(ce);
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Assertion Failure: Should have no illegal symbols");
            }
        }
    }

    public void zeroCounts() throws ChangeVetoException {
        if (this.changeSupport == null) {
            int i = 0;
            while (i < this.counts.length) {
                this.counts[i] = 0.0;
                ++i;
            }
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, Count.COUNTS);
                this.changeSupport.firePreChangeEvent(ce);
                int i = 0;
                while (i < this.counts.length) {
                    this.counts[i] = 0.0;
                    ++i;
                }
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public IndexedCount(FiniteAlphabet fa) {
        this(AlphabetManager.getAlphabetIndex(fa));
    }

    public IndexedCount(AlphabetIndex indexer) {
        indexer.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.indexer = indexer;
        this.counts = new double[indexer.getAlphabet().size()];
    }
}

