/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Line2D;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;

public class RulerRenderer
implements SequenceRenderer {
    private double depth = 25.0;

    public double getDepth(SequenceRenderContext src) {
        return this.depth + 1.0;
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        String lengthString = String.valueOf(src.getSymbols().length());
        Font f = src.getFont();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector gv = f.createGlyphVector(frc, lengthString);
        return gv.getVisualBounds().getWidth();
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        int minP;
        g.setPaint(Color.black);
        int min = src.getRange().getMin();
        int max = src.getRange().getMax();
        double minX = src.sequenceToGraphics(min);
        double maxX = src.sequenceToGraphics(max);
        double scale = src.getScale();
        double halfScale = scale * 0.5;
        Rectangle activeClip = g.getClipBounds();
        Line2D.Double line = src.getDirection() == 0 ? new Line2D.Double(minX - halfScale, 0.0, maxX + halfScale, 0.0) : new Line2D.Double(0.0, minX - halfScale, 0.0, maxX + halfScale);
        g.draw(line);
        double ten = Math.log(10.0);
        FontMetrics myFontMetrics = g.getFontMetrics();
        int coordWidth = myFontMetrics.stringWidth(Integer.toString(max));
        double minGap = Math.max(coordWidth, 40);
        int realSymsPerGap = (int)Math.ceil((minGap + 5.0) / src.getScale());
        double exponent = Math.floor(Math.log(realSymsPerGap) / ten);
        double characteristic = (double)realSymsPerGap / Math.pow(10.0, exponent);
        int snapSymsPerGap = characteristic > 5.0 ? (int)Math.pow(10.0, exponent + 1.0) : (characteristic > 2.0 ? (int)(5.0 * Math.pow(10.0, exponent)) : (int)(2.0 * Math.pow(10.0, exponent)));
        int indx = minP = min + (snapSymsPerGap - min) % snapSymsPerGap;
        while (indx <= max) {
            double offset = src.sequenceToGraphics(indx);
            if (src.getDirection() == 0) {
                ((Line2D)line).setLine(offset + halfScale, 0.0, offset + halfScale, 5.0);
                String labelString = String.valueOf(indx);
                int halfLabelWidth = myFontMetrics.stringWidth(labelString) / 2;
                g.drawString(String.valueOf(indx), (float)(offset + halfScale - (double)halfLabelWidth), 20.0f);
            } else {
                ((Line2D)line).setLine(0.0, offset + halfScale, 5.0, offset + halfScale);
            }
            g.draw(line);
            indx += snapSymsPerGap;
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        int sPos = src.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }
}

