/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.program.search.SearchBuilder;
import org.biojava.bio.program.search.SearchParser;
import org.biojava.utils.ParserException;

public class SearchReader
implements Iterator {
    private BufferedReader reader;
    private SearchBuilder handler;
    private SearchParser parser;
    private boolean moreSearchesAvailable = true;

    public SearchReader(BufferedReader reader, SearchBuilder handler, SearchParser parser) {
        this.reader = reader;
        this.handler = handler;
        this.parser = parser;
    }

    public boolean hasNext() {
        if (!this.moreSearchesAvailable) {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                System.err.println("Failed to close reader cleanly");
                ioe.printStackTrace();
            }
        }
        return this.moreSearchesAvailable;
    }

    public Object next() throws NoSuchElementException {
        try {
            if (!this.moreSearchesAvailable) {
                this.reader.close();
                throw new NoSuchElementException("Attempt to read search result from empty stream");
            }
            try {
                this.parser.parseSearch(this.reader, this.handler);
                this.moreSearchesAvailable = this.handler.getMoreSearches();
                return this.handler.makeSearchResult();
            }
            catch (ParserException pe) {
                this.reader.close();
                throw new NoSuchElementException("No valid search result could be parsed from this stream: parse failed at line " + pe.getLineNumber() + " of input: " + pe.getMessage());
            }
            catch (BioException be) {
                this.reader.close();
                throw new NoSuchElementException("No valid search result could be parsed from this stream: " + be.getMessage());
            }
        }
        catch (IOException ioe) {
            try {
                this.reader.close();
            }
            catch (IOException ioe2) {
                System.err.println("Failed to close reader cleanly");
            }
            throw new NoSuchElementException("No valid search result could be parsed from this stream");
        }
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

