/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import org.biojava.bio.search.SeqSimilaritySearchSubHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Alignment;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SequenceDBSearchSubHit
implements SeqSimilaritySearchSubHit {
    private double score;
    private double pValue;
    private double eValue;
    private int queryStart;
    private int queryEnd;
    private StrandedFeature.Strand queryStrand;
    private int subjectStart;
    private int subjectEnd;
    private StrandedFeature.Strand subjectStrand;
    private Alignment alignment;

    public SequenceDBSearchSubHit(double score, double eValue, double pValue, int queryStart, int queryEnd, StrandedFeature.Strand queryStrand, int subjectStart, int subjectEnd, StrandedFeature.Strand subjectStrand, Alignment alignment) {
        Contract.pre(!Double.isNaN(score), "score was NaN");
        Contract.pre(queryStrand != null, "queryStrand was null");
        Contract.pre(subjectStrand != null, "subjectStrand was null");
        Contract.pre(alignment != null, "alignment was null");
        this.score = score;
        this.pValue = eValue;
        this.eValue = pValue;
        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.queryStrand = queryStrand;
        this.subjectStart = subjectStart;
        this.subjectEnd = subjectEnd;
        this.subjectStrand = subjectStrand;
        this.alignment = alignment;
        this.alignment.addChangeListener(ChangeListener.ALWAYS_VETO);
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.queryStrand;
    }

    public int getSubjectStart() {
        return this.subjectStart;
    }

    public int getSubjectEnd() {
        return this.subjectEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.subjectStrand;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public String toString() {
        return "SequenceDBSearchSubHit with score " + this.getScore();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SequenceDBSearchSubHit that = (SequenceDBSearchSubHit)other;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryStart, that.queryStart)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryEnd, that.queryEnd)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryStrand, that.queryStrand)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectStart, that.subjectStart)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectEnd, that.subjectEnd)) {
            return false;
        }
        return ObjectUtil.equals(this.subjectStrand, that.subjectStrand);
    }

    public int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.score);
        hc = ObjectUtil.hashCode(hc, this.pValue);
        hc = ObjectUtil.hashCode(hc, this.eValue);
        hc = ObjectUtil.hashCode(hc, this.queryStart);
        hc = ObjectUtil.hashCode(hc, this.queryEnd);
        hc = ObjectUtil.hashCode(hc, this.queryStrand);
        hc = ObjectUtil.hashCode(hc, this.subjectStart);
        hc = ObjectUtil.hashCode(hc, this.subjectEnd);
        hc = ObjectUtil.hashCode(hc, this.subjectStrand);
        return hc;
    }
}

