/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class CompoundLocation
extends AbstractLocation
implements Location,
Serializable {
    private List locations;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    CompoundLocation(List locs) {
        this.locations = new ArrayList();
        Location minL = (Location)locs.get(0);
        Location maxL = (Location)locs.get(locs.size() - 1);
        this.locations.addAll(locs);
        this.min = minL.getMin();
        this.max = maxL.getMax();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean contains(int p) {
        if (p < this.min || p > this.max) {
            return false;
        }
        Iterator i = this.locations.iterator();
        while (i.hasNext()) {
            if (!((Location)i.next()).contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Location l) {
        return LocationTools.contains(this, l);
    }

    public boolean overlaps(Location l) {
        return LocationTools.overlaps(this, l);
    }

    public Location union(Location loc) {
        return LocationTools.union(this, loc);
    }

    public Location intersection(Location loc) {
        return LocationTools.intersection(this, loc);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        return LocationTools.areEqual(this, (Location)o);
    }

    public SymbolList symbols(SymbolList seq) {
        if (this.isContiguous()) {
            return seq.subList(this.min, this.max);
        }
        ArrayList res = new ArrayList();
        Iterator i = this.blockIterator();
        while (i.hasNext()) {
            Location l = (Location)i.next();
            res.addAll(l.symbols(seq).toList());
        }
        try {
            return new SimpleSymbolList(seq.getAlphabet(), res);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    public Location translate(int dist) {
        if (dist == 0) {
            return this;
        }
        ArrayList<Location> res = new ArrayList<Location>();
        Iterator i = this.locations.iterator();
        while (i.hasNext()) {
            res.add(((Location)i.next()).translate(dist));
        }
        return new CompoundLocation(res);
    }

    public boolean isContiguous() {
        return this.locations.size() <= 1;
    }

    public Iterator blockIterator() {
        return this.locations.iterator();
    }

    public int hashCode() {
        return this.getMin() ^ this.getMax();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMin() + ", " + this.getMax() + " {");
        Iterator i = this.locations.iterator();
        if (i.hasNext()) {
            sb.append("(" + i.next() + ")");
        }
        while (i.hasNext()) {
            sb.append(", (" + i.next() + ")");
        }
        sb.append("}");
        return sb.toString();
    }
}

