/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.NestedError;
import org.biojava.utils.query.Arc;
import org.biojava.utils.query.Node;
import org.biojava.utils.query.Operation;
import org.biojava.utils.query.OperationException;
import org.biojava.utils.query.Query;
import org.biojava.utils.query.QueryData;
import org.biojava.utils.query.SimpleQuery;
import org.biojava.utils.query.Type;
import org.biojava.utils.query.TypeCastException;

public class QueryBuilder
extends QueryData {
    public void addQuery(Query query) {
        Iterator i = query.getArcsToOperators().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry arcOp = i.next();
            Arc arc = (Arc)arcOp.getKey();
            Set opSet = (Set)arcOp.getValue();
            try {
                Iterator oi = opSet.iterator();
                while (oi.hasNext()) {
                    Operation op = (Operation)oi.next();
                    this.addArc(arc, op);
                }
            }
            catch (OperationException oe) {
                throw new NestedError(oe, "This should never happen");
            }
        }
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
        Iterator i = new HashSet(this.getArcsFrom(node)).iterator();
        while (i.hasNext()) {
            Arc arc = (Arc)i.next();
            this.removeArc(arc);
        }
        Iterator i2 = new HashSet(this.getArcsTo(node)).iterator();
        while (i2.hasNext()) {
            Arc arc = (Arc)i2.next();
            this.removeArc(arc);
        }
    }

    public void addArc(Arc arc, Operation op) throws OperationException {
        try {
            QueryBuilder.checkTypes(op.getInputType(), arc.from.getOutputType());
        }
        catch (TypeCastException tce) {
            throw new TypeCastException(tce, " while connecting from node " + arc.from + " to operation " + op);
        }
        try {
            QueryBuilder.checkTypes(arc.to.getInputType(), op.getOutputType());
        }
        catch (TypeCastException tce) {
            throw new TypeCastException(tce, " while connecting from operation " + op + " to node " + arc.to);
        }
        this.nodes.add(arc.from);
        this.nodes.add(arc.to);
        this.getSet(arc, this.operationsToLabel).add(op);
        this.getSet(arc.from, this.arcsFrom).add(arc);
        this.getSet(arc.to, this.arcsTo).add(arc);
    }

    public void removeArc(Arc arc) {
        this.operationsToLabel.remove(arc);
        this.removeSet(arc.from, arc, this.arcsFrom);
        this.removeSet(arc.to, arc, this.arcsTo);
    }

    public void removeArc(Arc arc, Operation op) {
        this.removeSet(arc, op, this.operationsToLabel);
        if (this.operationsToLabel.get(arc) == null) {
            this.removeSet(arc.from, arc, this.arcsFrom);
            this.removeSet(arc.to, arc, this.arcsTo);
        }
    }

    private Set getSet(Object key, Map map) {
        HashSet result = (HashSet)map.get(key);
        if (result == null) {
            result = new HashSet();
            map.put(key, result);
        }
        return result;
    }

    private void removeSet(Object key, Object value, Map map) {
        Set set = (Set)map.get(key);
        if (set != null) {
            set.remove(value);
            if (set.size() == 0) {
                map.remove(key);
            }
        }
    }

    public Query buildQuery() {
        return new SimpleQuery(this);
    }

    private static void checkTypes(Type superType, Type subType) {
        if (!superType.isAssignableFrom(subType)) {
            throw new TypeCastException("Invalid operation input: can't assign to " + superType + " from " + subType);
        }
    }
}

