/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Count;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IndexedCount;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public final class SimpleDistribution
extends AbstractDistribution
implements Serializable {
    private transient AlphabetIndex indexer;
    private double[] weights = null;
    private Distribution nullModel;

    public SimpleDistribution(FiniteAlphabet finiteAlphabet) {
        this.indexer = AlphabetManager.getAlphabetIndex(finiteAlphabet);
        this.indexer.addChangeListener(new ChangeAdapter(){

            public void preChange(ChangeEvent changeEvent) throws ChangeVetoException {
                if (SimpleDistribution.this.hasWeights()) {
                    throw new ChangeVetoException(changeEvent, "Can't allow the index to change as we have probabilities.");
                }
            }
        }, AlphabetIndex.INDEX);
        try {
            this.setNullModel(new UniformDistribution(finiteAlphabet));
        }
        catch (Exception exception) {
            throw new BioError(exception, "This should never fail. Something is screwed!");
        }
    }

    public Alphabet getAlphabet() {
        return this.indexer.getAlphabet();
    }

    public Distribution getNullModel() {
        return this.nullModel;
    }

    public double getWeightImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        if (!this.hasWeights()) {
            return Double.NaN;
        }
        return this.weights[this.indexer.indexForSymbol(atomicSymbol)];
    }

    protected double[] getWeights() {
        if (this.weights == null) {
            this.weights = new double[this.indexer.getAlphabet().size()];
            int n = 0;
            while (n < this.weights.length) {
                this.weights[n] = Double.NaN;
                ++n;
            }
        }
        return this.weights;
    }

    protected boolean hasWeights() {
        return this.weights != null;
    }

    public void registerWithTrainer(DistributionTrainerContext distributionTrainerContext) {
        distributionTrainerContext.registerTrainer(this, new Trainer());
    }

    protected void setNullModelImpl(Distribution distribution) throws IllegalAlphabetException, ChangeVetoException {
        this.nullModel = distribution;
    }

    protected void setWeightImpl(AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException, ChangeVetoException {
        double[] dArray = this.getWeights();
        if (d < 0.0) {
            throw new IllegalArgumentException("Can't set weight to negative score: " + atomicSymbol.getName() + " -> " + d);
        }
        dArray[this.indexer.indexForSymbol((Symbol)atomicSymbol)] = d;
    }

    private class Trainer
    implements DistributionTrainer {
        private final Count counts;

        public Trainer() {
            this.counts = new IndexedCount(SimpleDistribution.this.indexer);
        }

        public void addCount(DistributionTrainerContext distributionTrainerContext, AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException {
            try {
                this.counts.increaseCount(atomicSymbol, d);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Assertion Failure: Change to Count object vetoed");
            }
        }

        public void clearCounts() {
            try {
                int n = ((FiniteAlphabet)this.counts.getAlphabet()).size();
                int n2 = 0;
                while (n2 < n) {
                    this.counts.zeroCounts();
                    ++n2;
                }
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Assertion Failure: Change to Count object vetoed");
            }
        }

        public void train(double d) throws ChangeVetoException {
            if (SimpleDistribution.this.changeSupport == null) {
                this.trainImpl(d);
            } else {
                ChangeSupport changeSupport = SimpleDistribution.this.changeSupport;
                synchronized (changeSupport) {
                    ChangeEvent changeEvent = new ChangeEvent(SimpleDistribution.this, Distribution.WEIGHTS);
                    SimpleDistribution.this.changeSupport.firePreChangeEvent(changeEvent);
                    this.trainImpl(d);
                    SimpleDistribution.this.changeSupport.firePostChangeEvent(changeEvent);
                }
            }
        }

        protected void trainImpl(double d) {
            try {
                Distribution distribution = SimpleDistribution.this.getNullModel();
                double[] dArray = SimpleDistribution.this.getWeights();
                double[] dArray2 = new double[dArray.length];
                double d2 = 0.0;
                int n = 0;
                while (n < dArray2.length) {
                    AtomicSymbol atomicSymbol = (AtomicSymbol)SimpleDistribution.this.indexer.symbolForIndex(n);
                    dArray2[n] = this.counts.getCount(atomicSymbol) + distribution.getWeight(atomicSymbol) * d;
                    d2 += dArray2[n];
                    ++n;
                }
                double d3 = 1.0 / d2;
                int n2 = 0;
                while (n2 < dArray2.length) {
                    dArray[n2] = dArray2[n2] * d3;
                    ++n2;
                }
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Assertion Failure: Should be impossible to mess up the symbols.");
            }
        }
    }
}

