/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.io.Serializable;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.SymbolList;

public class SingleDPMatrix
implements DPMatrix,
Serializable {
    private final State[] states;
    private final MarkovModel model;
    private final SymbolList[] symList;
    public final double[][] scores;
    private double score;

    public SingleDPMatrix(DP dP, SymbolList symbolList) {
        this.model = dP.getModel();
        this.states = dP.getStates();
        this.symList = new SymbolList[]{symbolList};
        this.score = Double.NaN;
        this.scores = new double[symbolList.length() + 2][this.states.length];
    }

    public double getCell(int[] nArray) throws IndexOutOfBoundsException {
        if (nArray.length != 2) {
            throw new IndexOutOfBoundsException("index must be two-dimensional");
        }
        return this.scores[nArray[1]][nArray[0]];
    }

    public double getScore() {
        return this.score;
    }

    public MarkovModel model() {
        return this.model;
    }

    void setScore(double d) {
        this.score = d;
    }

    public State[] states() {
        return this.states;
    }

    public SymbolList[] symList() {
        return this.symList;
    }
}

