/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import org.biojava.bio.gui.sequence.AbstractForwarder;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class FilteringRenderer
extends AbstractForwarder
implements SequenceRenderer {
    public static ChangeType RENDERER = new ChangeType("The renderer used to render the filtered features has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "RENDERER");
    public static ChangeType FILTER = new ChangeType("The filter has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "FILTER");
    public static ChangeType RECURSE = new ChangeType("The recurse for the filter has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "RECURSE");
    protected SequenceRenderer lineRenderer;
    protected FeatureFilter filter;
    protected boolean recurse;

    public FilteringRenderer() {
        this.filter = FeatureFilter.all;
        this.recurse = false;
    }

    public FilteringRenderer(SequenceRenderer sequenceRenderer, FeatureFilter featureFilter, boolean bl) {
        try {
            this.setLineRenderer(sequenceRenderer);
            this.setFilter(featureFilter);
            this.setRecurse(bl);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new NestedError(changeVetoException, "Assertion Failure: Should have no listeners");
        }
    }

    protected SequenceRenderContext getContext(SequenceRenderContext sequenceRenderContext) {
        if (this.filter == FeatureFilter.all && this.recurse) {
            return sequenceRenderContext;
        }
        return new SubSequenceRenderContext(sequenceRenderContext, ((Sequence)sequenceRenderContext.getSequence()).filter(this.filter, this.recurse));
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, int n, int n2) {
        return this.getLineRenderer().getDepth(this.getContext(sequenceRenderContext), n, n2);
    }

    public FeatureFilter getFilter() {
        return this.filter;
    }

    public SequenceRenderer getLineRenderer() {
        return this.lineRenderer;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext) {
        return this.getLineRenderer().getMinimumLeader(this.getContext(sequenceRenderContext));
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext) {
        return this.getLineRenderer().getMinimumTrailer(this.getContext(sequenceRenderContext));
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, int n, int n2) {
        this.getLineRenderer().paint(graphics2D, this.getContext(sequenceRenderContext), n, n2);
    }

    public void setFilter(FeatureFilter featureFilter) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FILTER);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, FILTER, this.filter, featureFilter));
                changeSupport.firePreChangeEvent(changeEvent);
                this.filter = featureFilter;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.filter = featureFilter;
        }
    }

    public void setLineRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERER);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, RENDERER, sequenceRenderer, this.lineRenderer));
                changeSupport.firePreChangeEvent(changeEvent);
                this.setLineRendererImpl(sequenceRenderer);
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.setLineRendererImpl(sequenceRenderer);
        }
    }

    protected void setLineRendererImpl(SequenceRenderer sequenceRenderer) {
        this.unregisterLayout(this.lineRenderer, SequenceRenderContext.LAYOUT);
        this.unregisterRepaint(this.lineRenderer, SequenceRenderContext.REPAINT);
        this.lineRenderer = sequenceRenderer;
        this.registerLayout(this.lineRenderer, SequenceRenderContext.LAYOUT);
        this.registerRepaint(this.lineRenderer, SequenceRenderContext.REPAINT);
    }

    public void setRecurse(boolean bl) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RECURSE);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, RECURSE, this.filter, this.filter));
                changeSupport.firePreChangeEvent(changeEvent);
                this.filter = this.filter;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.filter = this.filter;
        }
    }
}

