/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DASGFFParser {
    static final DASGFFParser INSTANCE = new DASGFFParser();

    private DASGFFParser() {
    }

    private String getChildText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Text) {
                stringBuffer.append(((Text)node).getData());
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString().trim();
    }

    private Feature.Template parseDASFeature(Element element) throws NumberFormatException, ParseException {
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = "unknown";
        String string4 = "unknown";
        int n = -1;
        int n2 = -1;
        String string5 = "0";
        String string6 = "-";
        Object var10_10 = null;
        boolean bl = false;
        String string7 = null;
        String string8 = null;
        int n3 = -1;
        int n4 = -1;
        string = element.getAttribute("id");
        string2 = element.getAttribute("label");
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Object object3;
                object2 = (Element)node;
                object = object2.getTagName();
                if (((String)object).equals("TYPE")) {
                    string3 = this.getChildText((Element)object2);
                    object3 = object2.getAttribute("reference");
                    if ("yes".equals(object3)) {
                        bl = true;
                    }
                    string7 = object2.getAttribute("category");
                } else if (((String)object).equals("METHOD")) {
                    string4 = this.getChildText((Element)object2);
                } else if (((String)object).equals("START")) {
                    n = Integer.parseInt(this.getChildText((Element)object2));
                } else if (((String)object).equals("END")) {
                    n2 = Integer.parseInt(this.getChildText((Element)object2));
                } else if (((String)object).equals("ORIENTATION")) {
                    string5 = this.getChildText((Element)object2);
                } else if (((String)object).equals("PHASE")) {
                    string6 = this.getChildText((Element)object2);
                } else if (((String)object).equals("GROUP")) {
                    object3 = object2.getFirstChild();
                    while (object3 != null) {
                        Element element2;
                        String string9;
                        if (object3 instanceof Element && (string9 = (element2 = (Element)object3).getTagName()).equals("TARGET")) {
                            string8 = element2.getAttribute("ref");
                            n3 = Integer.parseInt(element2.getAttribute("start"));
                            n4 = Integer.parseInt(element2.getAttribute("stop"));
                        }
                        object3 = object3.getNextSibling();
                    }
                }
            }
            node = node.getNextSibling();
        }
        object2 = null;
        if (bl && string7.equals("component")) {
            if (string8 == null) {
                throw new ParseException("Can't template componentFeature without a specified TARGET");
            }
            object = new ComponentFeature.Template();
            ((ComponentFeature.Template)object).componentLocation = new RangeLocation(n3, n4);
            ((StrandedFeature.Template)object).strand = string5.equals("+") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
            ((Feature.Template)object).annotation = new SimpleAnnotation();
            try {
                ((Feature.Template)object).annotation.setProperty("sequence.id", string8);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException);
            }
            object2 = object;
        } else if (string5.equals("+") || string5.equals("-")) {
            object = new StrandedFeature.Template();
            ((StrandedFeature.Template)object).strand = string5.equals("+") ? StrandedFeature.POSITIVE : StrandedFeature.NEGATIVE;
            object2 = object;
        } else {
            object2 = new Feature.Template();
        }
        ((Feature.Template)object2).type = string3;
        ((Feature.Template)object2).source = string4;
        ((Feature.Template)object2).location = var10_10 == null ? new RangeLocation(n, n2) : var10_10;
        if (((Feature.Template)object2).annotation == null) {
            ((Feature.Template)object2).annotation = new SimpleAnnotation();
        }
        try {
            if (string.length() > 0) {
                ((Feature.Template)object2).annotation.setProperty("org.biojava.bio.program.das.feature_id", string);
            }
            if (string2.length() > 0) {
                ((Feature.Template)object2).annotation.setProperty("org.biojava.bio.program.das.feature_label", string2);
            }
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException);
        }
        return object2;
    }

    public void parseURL(URL uRL, SeqIOListener seqIOListener) throws BioException, ParseException, IOException {
        try {
            String string;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioError("Not a DAS server: " + uRL.toString());
            }
            if (n != 200) {
                throw new BioError("DAS error (status code = " + n + ")");
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("GFF");
            if (nodeList.getLength() != 1) {
                throw new BioException("Couldn't find GFF element");
            }
            element = (Element)nodeList.item(0);
            String string2 = element.getAttribute("version");
            if (string2 == null || !string2.equals("0.95")) {
                throw new BioException("Unrecognized DASGFF version " + string2);
            }
            NodeList nodeList2 = element.getElementsByTagName("SEGMENT");
            if (nodeList2.getLength() != 1) {
                throw new BioException("DASGFF documents must contain one SEGMENT");
            }
            element = (Element)nodeList2.item(0);
            seqIOListener.startSequence();
            String string3 = element.getAttribute("start");
            if (string3 != null) {
                seqIOListener.addSequenceProperty("sequence.start", string3);
            }
            if ((string = element.getAttribute("stop")) != null) {
                seqIOListener.addSequenceProperty("sequence.stop", string);
            }
            Node node = element.getFirstChild();
            while (node != null) {
                Element element2;
                if (node instanceof Element && (element2 = (Element)node).getTagName().equals("FEATURE")) {
                    Feature.Template template = this.parseDASFeature(element2);
                    seqIOListener.startFeature(template);
                    seqIOListener.endFeature();
                }
                node = node.getNextSibling();
            }
            seqIOListener.endSequence();
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
    }
}

