/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASCapabilities;
import org.biojava.bio.program.das.DASGFFParser;
import org.biojava.bio.program.das.DASXFFParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class FeatureRequestManager {
    private static Map requestManagers = new HashMap();
    private Set openTickets = new HashSet();
    private URL dataSourceURL;

    public FeatureRequestManager(URL uRL) {
        this.dataSourceURL = uRL;
    }

    private boolean fetchAll() throws ParseException, BioException {
        try {
            if (this.openTickets.size() <= 1) {
                return false;
            }
            boolean bl = DASCapabilities.checkCapable(new URL(this.dataSourceURL, ".."), "dasExtendedRequest", "features");
            if (!bl) {
                return false;
            }
            URL uRL = new URL(this.dataSourceURL, "features");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            HashMap<String, Ticket> hashMap = new HashMap<String, Ticket>();
            printStream.println("<featureRequest encoding=\"xff\">");
            Iterator iterator = this.openTickets.iterator();
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                printStream.println("  <segment id=\"" + ticket.getID() + "\" />");
                hashMap.put(ticket.getID(), ticket);
            }
            printStream.println("</featureRequest>");
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioError("Not a DAS server: " + uRL.toString());
            }
            if (n != 200) {
                throw new BioError("DAS error (status code = " + n + ")");
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Object object;
                    String string;
                    Element element2 = (Element)node;
                    String string2 = element2.getTagName();
                    if ("SEGMENT".equals(string2)) {
                        string = element2.getAttribute("id");
                        object = (Ticket)hashMap.get(string);
                        if (object == null) {
                            throw new ParseException("Response segment " + string + " wasn't requested");
                        }
                        DASXFFParser.INSTANCE.parseSegment(element2, ((Ticket)object).getOutputListener());
                        ((Ticket)object).setAsFetched();
                        this.openTickets.remove(object);
                    } else if ("segmentError".equals(string2)) {
                        string = element2.getAttribute("id");
                        object = element2.getAttribute("error");
                        throw new ParseException("Error " + (String)object + " fetching " + string);
                    }
                }
                node = node.getNextSibling();
            }
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
        return true;
    }

    private void fetchTicket(Ticket ticket) throws ParseException, BioException {
        try {
            boolean bl = DASCapabilities.checkCapable(new URL(this.dataSourceURL, ".."), "featureTable", "xff");
            if (bl) {
                URL uRL = new URL(this.dataSourceURL, "features?encoding=xff;ref=" + ticket.getID());
                DASXFFParser.INSTANCE.parseURL(uRL, ticket.getOutputListener());
            } else {
                URL uRL = new URL(this.dataSourceURL, "features?ref=" + ticket.getID());
                DASGFFParser.INSTANCE.parseURL(uRL, ticket.getOutputListener());
            }
            this.openTickets.remove(ticket);
            ticket.setAsFetched();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public static FeatureRequestManager getManager(URL uRL) {
        FeatureRequestManager featureRequestManager = (FeatureRequestManager)requestManagers.get(uRL);
        if (featureRequestManager == null) {
            featureRequestManager = new FeatureRequestManager(uRL);
            requestManagers.put(uRL, featureRequestManager);
        }
        return featureRequestManager;
    }

    public Ticket requestFeatures(String string, SeqIOListener seqIOListener) {
        Ticket ticket = new Ticket(string, seqIOListener);
        this.openTickets.add(ticket);
        return ticket;
    }

    public class Ticket {
        private boolean _isFired = false;
        private String id;
        private SeqIOListener outputListener;

        public Ticket(String string, SeqIOListener seqIOListener) {
            this.id = string;
            this.outputListener = seqIOListener;
        }

        public void doFetch() throws ParseException, BioException {
            if (!this._isFired && !FeatureRequestManager.this.fetchAll()) {
                FeatureRequestManager.this.fetchTicket(this);
            }
        }

        private String getID() {
            return this.id;
        }

        private SeqIOListener getOutputListener() {
            return this.outputListener;
        }

        public boolean isFetched() {
            return this._isFired;
        }

        private void setAsFetched() {
            this._isFired = true;
            this.id = null;
            this.outputListener = null;
        }
    }
}

