/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;

public interface FeatureFilter
extends Serializable {
    public static final FeatureFilter all = new AcceptAllFilter();

    public boolean accept(Feature var1);

    public static final class AcceptAllFilter
    implements FeatureFilter {
        public boolean accept(Feature feature) {
            return true;
        }
    }

    public static final class ByType
    implements FeatureFilter {
        private String type;

        public ByType(String string) {
            this.type = string;
        }

        public boolean accept(Feature feature) {
            return this.type.equals(feature.getType());
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class BySource
    implements FeatureFilter {
        private String source;

        public BySource(String string) {
            this.source = string;
        }

        public boolean accept(Feature feature) {
            return this.source.equals(feature.getSource());
        }

        public String getSource() {
            return this.source;
        }
    }

    public static final class ByClass
    implements FeatureFilter {
        private Class clazz;

        public ByClass(Class clazz) {
            this.clazz = clazz;
        }

        public boolean accept(Feature feature) {
            return this.clazz.isInstance(feature);
        }

        public Class getTestClass() {
            return this.clazz;
        }
    }

    public static final class ContainedByLocation
    implements FeatureFilter {
        private Location loc;

        public ContainedByLocation(Location location) {
            this.loc = location;
        }

        public boolean accept(Feature feature) {
            return this.loc.contains(feature.getLocation());
        }

        public Location getLocation() {
            return this.loc;
        }
    }

    public static final class OverlapsLocation
    implements FeatureFilter {
        private Location loc;

        public OverlapsLocation(Location location) {
            this.loc = location;
        }

        public boolean accept(Feature feature) {
            return this.loc.overlaps(feature.getLocation());
        }

        public Location getLocation() {
            return this.loc;
        }
    }

    public static final class Not
    implements FeatureFilter {
        FeatureFilter child;

        public Not(FeatureFilter featureFilter) {
            this.child = featureFilter;
        }

        public boolean accept(Feature feature) {
            return this.child.accept(feature) ^ true;
        }

        public FeatureFilter getChild() {
            return this.child;
        }
    }

    public static final class And
    implements FeatureFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public And(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
            this.c1 = featureFilter;
            this.c2 = featureFilter2;
        }

        public boolean accept(Feature feature) {
            return this.c1.accept(feature) && this.c2.accept(feature);
        }

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }
    }

    public static final class Or
    implements FeatureFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public Or(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
            this.c1 = featureFilter;
            this.c2 = featureFilter2;
        }

        public boolean accept(Feature feature) {
            return this.c1.accept(feature) || this.c2.accept(feature);
        }

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }
    }

    public static final class ByAnnotation
    implements FeatureFilter {
        private Object key;
        private Object value;

        public ByAnnotation(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public boolean accept(Feature feature) {
            Annotation annotation = feature.getAnnotation();
            try {
                Object object = annotation.getProperty(this.key);
                if (object == null) {
                    return this.value == null;
                }
                return object.equals(this.value);
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static final class HasAnnotation
    implements FeatureFilter {
        private Object key;

        public HasAnnotation(Object object) {
            this.key = object;
        }

        public boolean accept(Feature feature) {
            Annotation annotation = feature.getAnnotation();
            try {
                Object object = annotation.getProperty(this.key);
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static final class StrandFilter
    implements FeatureFilter {
        private StrandedFeature.Strand strand;

        public StrandFilter(StrandedFeature.Strand strand) {
            this.strand = strand;
        }

        public boolean accept(Feature feature) {
            if (feature instanceof StrandedFeature) {
                StrandedFeature strandedFeature = (StrandedFeature)feature;
                return strandedFeature.getStrand() == this.strand;
            }
            return this.strand == StrandedFeature.UNKNOWN;
        }

        public StrandedFeature.Strand getStrand() {
            return this.strand;
        }
    }
}

