/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.OverlayAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ViewSequence
implements Sequence,
RealizingFeatureHolder {
    private Sequence seqDelegate;
    private MergeFeatureHolder exposedFeatures;
    private SimpleFeatureHolder addedFeatures;
    private String name;
    private String urn;
    private Annotation anno;
    private FeatureRealizer featureRealizer;

    public ViewSequence(Sequence sequence) {
        this.seqDelegate = sequence;
        this.addedFeatures = new SimpleFeatureHolder();
        this.exposedFeatures = new MergeFeatureHolder();
        this.exposedFeatures.addFeatureHolder(new ProjectedFeatureHolder(this.seqDelegate, this, 0, false));
        this.exposedFeatures.addFeatureHolder(this.addedFeatures);
        this.name = this.seqDelegate.getName();
        this.urn = this.seqDelegate.getURN();
        this.urn = this.urn.indexOf(63) >= 0 ? String.valueOf(this.urn) + "&view=" + this.hashCode() : String.valueOf(this.urn) + "?view=" + this.hashCode();
        this.anno = new OverlayAnnotation(this.seqDelegate.getAnnotation());
        this.featureRealizer = FeatureImpl.DEFAULT;
    }

    public ViewSequence(Sequence sequence, FeatureRealizer featureRealizer) {
        this(sequence);
        this.featureRealizer = featureRealizer;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    private static boolean containsRecurse(FeatureHolder featureHolder, Feature feature) {
        Iterator iterator = featureHolder.features();
        while (iterator.hasNext()) {
            if (iterator.next() != feature) continue;
            return true;
        }
        Iterator iterator2 = featureHolder.features();
        while (iterator2.hasNext()) {
            if (!ViewSequence.containsRecurse((FeatureHolder)iterator2.next(), feature)) continue;
            return true;
        }
        return false;
    }

    public int countFeatures() {
        return this.exposedFeatures.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        Location location = template.location;
        if (location.getMin() < 1 || location.getMax() > this.length()) {
            throw new BioException("Can't create a feature that is outside this sequence: " + location);
        }
        Feature feature = this.realizeFeature(this, template);
        this.addedFeatures.addFeature(feature);
        return feature;
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("ViewSequence is immutable");
    }

    public Iterator features() {
        return this.exposedFeatures.features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.exposedFeatures.filter(featureFilter, bl);
    }

    public FeatureHolder getAddedFeatures() {
        return this.addedFeatures;
    }

    public Alphabet getAlphabet() {
        return this.seqDelegate.getAlphabet();
    }

    public Annotation getAnnotation() {
        return this.anno;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.urn;
    }

    public Iterator iterator() {
        return this.seqDelegate.iterator();
    }

    public int length() {
        return this.seqDelegate.length();
    }

    public Feature realizeFeature(FeatureHolder featureHolder, Feature.Template template) throws BioException {
        return this.featureRealizer.realizeFeature(this, featureHolder, template);
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        this.addedFeatures.removeFeature(feature);
    }

    public String seqString() {
        return this.seqDelegate.seqString();
    }

    public SymbolList subList(int n, int n2) {
        return this.seqDelegate.subList(n, n2);
    }

    public String subStr(int n, int n2) {
        return this.seqDelegate.subStr(n, n2);
    }

    public Symbol symbolAt(int n) {
        return this.seqDelegate.symbolAt(n);
    }

    public List toList() {
        return this.seqDelegate.toList();
    }
}

