/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleSequence
implements Sequence,
RealizingFeatureHolder,
Serializable {
    private SymbolList symList;
    private String urn;
    private String name;
    private Annotation annotation;
    private SimpleFeatureHolder featureHolder;
    private FeatureRealizer featureRealizer;

    public SimpleSequence(SymbolList symbolList, String string, String string2, Annotation annotation) {
        this.symList = symbolList;
        this.setURN(string);
        this.setName(string2);
        this.annotation = annotation;
        this.featureRealizer = FeatureImpl.DEFAULT;
    }

    public SimpleSequence(SymbolList symbolList, String string, String string2, Annotation annotation, FeatureRealizer featureRealizer) {
        this.symList = symbolList;
        this.setURN(string);
        this.setName(string2);
        this.annotation = annotation;
        this.featureRealizer = featureRealizer;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public int countFeatures() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().countFeatures();
        }
        return 0;
    }

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        Feature feature = this.realizeFeature(this, template);
        SimpleFeatureHolder simpleFeatureHolder = this.getFeatureHolder();
        simpleFeatureHolder.addFeature(feature);
        return feature;
    }

    public Feature createFeature(FeatureHolder featureHolder, Feature.Template template) throws BioException, ChangeVetoException {
        return featureHolder.createFeature(template);
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit the underlying SymbolList");
    }

    protected boolean featureHolderAllocated() {
        return this.featureHolder != null;
    }

    public Iterator features() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().features();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().filter(featureFilter, bl);
        }
        return FeatureHolder.EMPTY_FEATURE_HOLDER;
    }

    public Alphabet getAlphabet() {
        return this.symList.getAlphabet();
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    protected SimpleFeatureHolder getFeatureHolder() {
        if (this.featureHolder == null) {
            this.featureHolder = new SimpleFeatureHolder();
        }
        return this.featureHolder;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.urn;
    }

    public Iterator iterator() {
        return this.symList.iterator();
    }

    public int length() {
        return this.symList.length();
    }

    public Feature realizeFeature(FeatureHolder featureHolder, Feature.Template template) throws BioException {
        return this.featureRealizer.realizeFeature(this, featureHolder, template);
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        this.getFeatureHolder().removeFeature(feature);
    }

    public String seqString() {
        return this.symList.seqString();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setURN(String string) {
        this.urn = string;
    }

    public SymbolList subList(int n, int n2) {
        return this.symList.subList(n, n2);
    }

    public String subStr(int n, int n2) {
        return this.symList.subStr(n, n2);
    }

    public Symbol symbolAt(int n) {
        return this.symList.symbolAt(n);
    }

    public List toList() {
        return this.symList.toList();
    }
}

