/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

class FeatureTableParser {
    private static final int WITHOUT = 0;
    protected static final int WITHIN = 1;
    protected static final int LOCATION = 2;
    protected static final int ATTRIBUTE = 3;
    protected int featureStatus = 0;
    protected StringBuffer featureBuf;
    private String featureType;
    protected Location featureLocation;
    protected Map featureAttributes;
    private StrandedFeature.Strand featureStrand;
    private String featureSource;
    private SeqIOListener listener;

    FeatureTableParser(SeqIOListener seqIOListener, String string) {
        this.listener = seqIOListener;
        this.featureSource = string;
        this.featureBuf = new StringBuffer();
        this.featureAttributes = new HashMap();
    }

    protected Feature.Template buildFeatureTemplate(String string, Location location, StrandedFeature.Strand strand, String string2, Map map) {
        StrandedFeature.Template template = new StrandedFeature.Template();
        template.annotation = new SimpleAnnotation();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                template.annotation.setProperty(entry.getKey(), entry.getValue());
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Assertion Failure: Couldn't set up the annotation");
            }
        }
        template.location = location;
        template.type = string;
        template.source = string2;
        template.strand = strand;
        return template;
    }

    protected int countChar(String string, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected int countChar(StringBuffer stringBuffer, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void endFeature() throws BioException {
        this.listener.startFeature(this.buildFeatureTemplate(this.featureType, this.featureLocation, this.featureStrand, this.featureSource, this.featureAttributes));
        this.listener.endFeature();
        this.featureStatus = 0;
    }

    public void featureData(String string) throws BioException {
        switch (this.featureStatus) {
            case 2: {
                this.featureBuf.append(string);
                if (this.countChar(this.featureBuf, '(') != this.countChar(this.featureBuf, ')')) break;
                this.featureLocation = this.parseLocation(this.featureBuf.toString());
                this.featureStatus = 1;
                break;
            }
            case 1: {
                if (string.charAt(0) == '/') {
                    if (this.countChar(string, '\"') % 2 == 0) {
                        this.processAttribute(string);
                        break;
                    }
                    this.featureBuf.setLength(0);
                    this.featureBuf.append(string);
                    this.featureStatus = 3;
                    break;
                }
                throw new BioException("Invalid line in feature body: " + string);
            }
            case 3: {
                this.featureBuf.append(string);
                if (this.countChar(this.featureBuf, '\"') % 2 != 0) break;
                this.processAttribute(this.featureBuf.toString());
                this.featureStatus = 1;
                break;
            }
        }
    }

    public boolean inFeature() {
        return this.featureStatus != 0;
    }

    private Location parseLocation(String string) throws BioException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = -1;
        Object object2 = null;
        ArrayList<Object> arrayList = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(),. ><", true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("join") || ((String)object).equals("order")) {
                bl = true;
                arrayList = new ArrayList<Object>();
                continue;
            }
            if (((String)object).equals("complement")) {
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (((String)object).equals("(")) {
                ++n2;
                continue;
            }
            if (((String)object).equals(")")) {
                --n2;
                continue;
            }
            if (((String)object).equals(".") || ((String)object).equals(",")) continue;
            if (((String)object).equals(">")) {
                if (bl4) {
                    bl6 = true;
                    continue;
                }
                bl5 = true;
                continue;
            }
            if (((String)object).equals("<")) {
                if (bl4) {
                    bl6 = true;
                    continue;
                }
                bl5 = true;
                continue;
            }
            if (((String)object).equals(" ")) continue;
            int n3 = -1;
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BioException("bad locator: " + (String)object + " " + string);
            }
            if (!bl4) {
                n = n3;
                bl4 = true;
                continue;
            }
            Location location = new RangeLocation(n, n3);
            if (bl5 || bl6) {
                location = new FuzzyLocation(location, bl5, bl6);
            }
            if (bl) {
                arrayList.add(location);
            } else {
                if (object2 != null) {
                    throw new BioException("Tried to set result to " + location + " when it was alredy set to " + object2);
                }
                object2 = location;
            }
            bl4 = false;
            bl2 = false;
            bl6 = false;
            bl5 = false;
        }
        if (n2 != 0) {
            throw new BioException("Mismatched parentheses: " + string);
        }
        if (bl4) {
            object = new PointLocation(n);
            if (bl) {
                arrayList.add(object);
            } else {
                if (object2 != null) {
                    throw new BioException();
                }
                object2 = object;
            }
        }
        this.featureStrand = bl3 ? StrandedFeature.NEGATIVE : StrandedFeature.POSITIVE;
        if (object2 == null) {
            if (arrayList == null) {
                throw new BioException("Location null: " + string);
            }
            object2 = new CompoundLocation(arrayList);
        }
        return object2;
    }

    protected void processAttribute(String string) throws BioException {
        int n = string.indexOf(61);
        if (n == -1) {
            this.featureAttributes.put(string.substring(1), Boolean.TRUE);
        } else {
            String string2;
            int n2;
            String string3 = string.substring(1, n);
            if (string.charAt(++n) == '\"') {
                ++n;
            }
            if (string.charAt((n2 = string.length()) - 1) == '\"') {
                --n2;
            }
            if ((string2 = string.substring(n, n2)).indexOf(34) >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                int n3 = 0;
                while (n3 < string2.length()) {
                    char c = string2.charAt(n3);
                    if (c == '\"') {
                        if (bl) {
                            stringBuffer.append(c);
                        }
                        bl ^= true;
                    } else {
                        stringBuffer.append(c);
                        bl = false;
                    }
                    ++n3;
                }
                string2 = stringBuffer.toString();
            }
            this.featureAttributes.put(string3, string2);
        }
    }

    public void startFeature(String string) throws BioException {
        this.featureType = string;
        this.featureStatus = 2;
        this.featureBuf.setLength(0);
        this.featureAttributes.clear();
    }
}

