/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.GenbankContext;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class GenbankFormat
implements SequenceFormat,
Serializable {
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String FEATURE_LINE_PREFIX = "     ";
    protected static final String FEATURE_FLAG = "FT";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String SIZE_TAG = "SIZE";
    protected static final String TYPE_TAG = "TYPE";
    protected static final String STRAND_NUMBER_TAG = "STRANDS";
    protected static final String CIRCULAR_TAG = "CIRCULAR";
    protected static final String DIVISION_TAG = "DIVISION";
    protected static final String DATE_TAG = "MDAT";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String GI_TAG = "GI";

    public boolean readSequence(BufferedReader bufferedReader, SymbolParser symbolParser, SeqIOListener seqIOListener) throws IllegalSymbolException, IOException, ParseException {
        String string;
        GenbankContext genbankContext = new GenbankContext(symbolParser, seqIOListener);
        StreamParser streamParser = null;
        boolean bl = true;
        seqIOListener.startSequence();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0) continue;
            if (string.startsWith(END_SEQUENCE_TAG)) {
                if (streamParser != null) {
                    streamParser.close();
                    streamParser = null;
                }
                bufferedReader.mark(2);
                if (bufferedReader.read() == -1) {
                    bl = false;
                } else {
                    bufferedReader.reset();
                }
                seqIOListener.endSequence();
                return bl;
            }
            genbankContext.processLine(string);
        }
        throw new IOException("Premature end of\tstream for GENBANK");
    }

    public void writeSequence(Sequence sequence, PrintStream printStream) throws IOException {
        throw new RuntimeException("Can't write\tin GENBANK format...");
    }
}

