/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.ChunkedSymbolListBuilder;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;

public class TokenParser
implements SymbolParser,
Serializable {
    private FiniteAlphabet alphabet;
    private transient Symbol[] symbolsByChar;

    public TokenParser(FiniteAlphabet finiteAlphabet) {
        this.alphabet = finiteAlphabet;
        this.installChangeListener();
    }

    static /* synthetic */ Symbol[] access$0(TokenParser tokenParser) {
        return tokenParser.symbolsByChar;
    }

    private void generateTable() {
        Object object;
        Object object2;
        Object object3;
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(AlphabetManager.getGapSymbol());
        Iterator iterator = this.alphabet.iterator();
        while (iterator.hasNext()) {
            object3 = (Symbol)iterator.next();
            hashSet.add(object3);
        }
        if (this.alphabet instanceof SimpleAlphabet) {
            object3 = ((SimpleAlphabet)this.alphabet).ambiguities();
            while (object3.hasNext()) {
                object2 = (Symbol)object3.next();
                hashSet.add(object2);
            }
        }
        int n = 0;
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (Symbol)object2.next();
            char c = object.getToken();
            n = Math.max(n, Character.toUpperCase(c));
            n = Math.max(n, Character.toLowerCase(c));
        }
        this.symbolsByChar = new Symbol[n + 1];
        object = hashSet.iterator();
        while (object.hasNext()) {
            Symbol symbol = (Symbol)object.next();
            char c = symbol.getToken();
            this.symbolsByChar[Character.toUpperCase((char)c)] = symbol;
            this.symbolsByChar[Character.toLowerCase((char)c)] = symbol;
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    private void installChangeListener() {
        this.alphabet.addChangeListener(new ChangeListener(){

            public void postChange(ChangeEvent changeEvent) {
                TokenParser.this.symbolsByChar = null;
            }

            public void preChange(ChangeEvent changeEvent) {
            }
        });
    }

    public SymbolList parse(String string) throws IllegalSymbolException {
        int n = string.length();
        if (n < 100) {
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>(string.length());
            int n2 = 0;
            while (n2 < string.length()) {
                arrayList.add(this.parseCharToken(string.charAt(n2)));
                ++n2;
            }
            return new SimpleSymbolList(this.getAlphabet(), arrayList);
        }
        Symbol[] symbolArray = new Symbol[256];
        ChunkedSymbolListBuilder chunkedSymbolListBuilder = new ChunkedSymbolListBuilder();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n3 < n && n4 < symbolArray.length) {
                symbolArray[n4++] = this.parseCharToken(string.charAt(n3++));
            }
            try {
                chunkedSymbolListBuilder.addSymbols(this.alphabet, symbolArray, 0, n4);
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException);
            }
        }
        return chunkedSymbolListBuilder.makeSymbolList();
    }

    Symbol parseCharToken(char c) throws IllegalSymbolException {
        if (this.symbolsByChar == null) {
            this.generateTable();
        }
        try {
            Symbol symbol = this.symbolsByChar[c];
            if (symbol != null) {
                return symbol;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new IllegalSymbolException("No symbol for token '" + c + "' found in alphabet " + this.alphabet.getName());
    }

    public StreamParser parseStream(SeqIOListener seqIOListener) {
        return new TPStreamParser(seqIOListener);
    }

    public Symbol parseToken(String string) throws IllegalSymbolException {
        if (string.length() > 1) {
            throw new IllegalSymbolException("All tokens recognized by this parser are single characters.");
        }
        return this.parseCharToken(string.charAt(0));
    }

    private class TPStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private Symbol[] buffer = new Symbol[256];

        public TPStreamParser(SeqIOListener seqIOListener) {
            this.listener = seqIOListener;
        }

        public void characters(char[] cArray, int n, int n2) throws IllegalSymbolException {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n3 < n2 && n4 < this.buffer.length) {
                    this.buffer[n4++] = TokenParser.this.parseCharToken(cArray[n + n3++]);
                }
                try {
                    this.listener.addSymbols(TokenParser.this.getAlphabet(), this.buffer, 0, n4);
                }
                catch (IllegalAlphabetException illegalAlphabetException) {
                    throw new BioError(illegalAlphabetException, "Assertion failed: can't add symbols.");
                }
            }
        }

        public void close() {
        }
    }
}

