/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class CompoundLocation
implements Location,
Serializable {
    private List locations;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    public CompoundLocation(List list) {
        Object object;
        this.locations = new ArrayList();
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = ((Location)iterator.next()).blockIterator();
            while (object.hasNext()) {
                Location location = (Location)object.next();
                if (location == Location.empty) continue;
                arrayList.add(location);
            }
        }
        Collections.sort(arrayList, Location.naturalOrder);
        object = Location.empty;
        int n = 0;
        while (n < arrayList.size()) {
            Location location = (Location)arrayList.get(n);
            if (location.getMin() - object.getMax() <= 1) {
                if (!object.contains(location)) {
                    object = new RangeLocation(Math.min(object.getMin(), location.getMin()), Math.max(object.getMax(), location.getMax()));
                }
            } else {
                if (object != Location.empty) {
                    this.locations.add(object);
                }
                object = location;
            }
            ++n;
        }
        if (object != Location.empty) {
            this.locations.add(object);
        }
        if (this.locations.size() != 0) {
            this.min = ((Location)this.locations.get(0)).getMin();
            this.max = ((Location)this.locations.get(this.locations.size() - 1)).getMax();
        }
    }

    public Iterator blockIterator() {
        return this.locations.iterator();
    }

    public boolean contains(int n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            if (!((Location)iterator.next()).contains(n)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Location location) {
        if (location.getMin() > this.max || location.getMax() < this.min) {
            return false;
        }
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            if (!((Location)iterator.next()).contains(location)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Location) {
            return Location.naturalOrder.areEqual(this, (Location)object);
        }
        return false;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public Location intersection(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            Location location2 = ((Location)iterator.next()).intersection(location);
            if (location2 == Location.empty) continue;
            arrayList.add(location2);
        }
        if (arrayList.size() != 0) {
            return new CompoundLocation(arrayList);
        }
        return Location.empty;
    }

    public boolean isContiguous() {
        return this.locations.size() <= 1;
    }

    public boolean overlaps(Location location) {
        if (location.getMin() > this.max || location.getMax() < this.min) {
            return false;
        }
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            if (!((Location)iterator.next()).overlaps(location)) continue;
            return true;
        }
        return false;
    }

    public SymbolList symbols(SymbolList symbolList) {
        if (this.isContiguous()) {
            return symbolList.subList(this.min, this.max);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.blockIterator();
        while (iterator.hasNext()) {
            Location location = (Location)iterator.next();
            arrayList.addAll(location.symbols(symbolList).toList());
        }
        try {
            return new SimpleSymbolList(symbolList.getAlphabet(), arrayList);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getMin()) + ", " + this.getMax() + " {");
        Iterator iterator = this.locations.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append("(" + iterator.next() + ")");
        }
        while (iterator.hasNext()) {
            stringBuffer.append(", (" + iterator.next() + ")");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Location translate(int n) {
        if (n == 0) {
            return this;
        }
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator iterator = this.locations.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Location)iterator.next()).translate(n));
        }
        return new CompoundLocation(arrayList);
    }

    public Location union(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>(this.locations);
        arrayList.add(location);
        return new CompoundLocation(arrayList);
    }
}

