/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.AttributeListEx;
import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWritable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private ElementNode nameScope;

    AttributeSet(AttributeSet original, boolean deep) {
        int size = original.getLength();
        this.list = new Vector(size);
        int i = 0;
        while (i < size) {
            Node node = original.item(i);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            node = node.cloneNode(deep);
            ((AttributeNode)node).setNameScope(null);
            this.list.addElement(node);
            ++i;
        }
    }

    AttributeSet(ElementNode nameScope) {
        this.list = new Vector(5);
        this.nameScope = nameScope;
    }

    AttributeSet(AttributeList source) throws DOMException {
        int len = source.getLength();
        AttributeListEx ex = null;
        this.list = new Vector(len);
        if (source instanceof AttributeListEx) {
            ex = (AttributeListEx)source;
        }
        int i = 0;
        while (i < len) {
            this.list.addElement(new AttributeNode(source.getName(i), source.getValue(i), ex == null ? true : ex.isSpecified(i), ex == null ? null : ex.getDefault(i)));
            ++i;
        }
        this.list.trimToSize();
    }

    public int getLength() {
        return this.list.size();
    }

    ElementNode getNameScope() {
        return this.nameScope;
    }

    public Node getNamedItem(String name) {
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            Node value = this.item(i);
            if (value.getNodeName().equals(name)) {
                return value;
            }
            ++i;
        }
        return null;
    }

    String getValue(String name) {
        Attr attr = (Attr)this.getNamedItem(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Node item(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(index);
    }

    public Node removeNamedItem(String name) throws DOMException {
        int length = this.list.size();
        if (this.readonly) {
            throw new DomEx(7);
        }
        int i = 0;
        while (i < length) {
            Node value = this.item(i);
            if (value.getNodeName().equals(name)) {
                AttributeNode att = (AttributeNode)value;
                if (att.getDefaultValue() != null) {
                    att = new AttributeNode(att);
                    att.setOwnerDocument((XmlDocument)this.nameScope.getOwnerDocument());
                    this.list.setElementAt(att, i);
                } else {
                    this.list.removeElementAt(i);
                }
                att.setNameScope(null);
                return value;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    void setNameScope(ElementNode e) {
        if (e != null && this.nameScope != null) {
            throw new IllegalStateException(e.getMessage("A-004"));
        }
        this.nameScope = e;
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode node = (AttributeNode)this.list.elementAt(i);
            node.setNameScope(null);
            node.setNameScope(e);
            ++i;
        }
    }

    public Node setNamedItem(Node value) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(value instanceof AttributeNode) || value.getOwnerDocument() != this.nameScope.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode node = (AttributeNode)value;
        if (node.getNameScope() != null) {
            throw new DomEx(10);
        }
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode oldValue = (AttributeNode)this.item(i);
            if (oldValue.getNodeName().equals(value.getNodeName())) {
                node.setNameScope(this.nameScope);
                this.list.setElementAt(value, i);
                oldValue.setNameScope(null);
                return oldValue;
            }
            ++i;
        }
        node.setNameScope(this.nameScope);
        this.list.addElement(value);
        return null;
    }

    void setReadonly() {
        this.readonly = true;
        int i = 0;
        while (i < this.list.size()) {
            ((AttributeNode)this.list.elementAt(i)).setReadonly(true);
            ++i;
        }
    }

    public String toString() {
        try {
            CharArrayWriter w = new CharArrayWriter();
            XmlWriteContext x = new XmlWriteContext(w);
            this.writeXml(x);
            return w.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode tmp = (AttributeNode)this.list.elementAt(i);
            if (tmp.getSpecified()) {
                out.write(32);
                tmp.writeXml(context);
            }
            ++i;
        }
    }
}

