/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.AttributeListEx;
import com.sun.xml.parser.DtdEventListener;
import com.sun.xml.parser.LexicalEventListener;
import com.sun.xml.parser.Parser;
import com.sun.xml.tree.AttributeSet;
import com.sun.xml.tree.Doctype;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.PINode;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.ParseContext;
import com.sun.xml.tree.TextNode;
import com.sun.xml.tree.XmlDocument;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.EntityReference;
import org.xml.sax.AttributeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDocumentBuilder
implements LexicalEventListener {
    private static final String xmlURI = "http://www.w3.com/XML/1998/namespace";
    private XmlDocument document;
    private Locator locator;
    private ParseContextImpl context = new ParseContextImpl();
    private Locale locale = Locale.getDefault();
    private ElementFactory factory;
    private Parser parser;
    private Vector attrTmp = new Vector();
    private ParentNode[] elementStack;
    private int topOfStack;
    private boolean inDTD;
    private boolean inCDataSection;
    private boolean ignoringLexicalInfo = true;
    private boolean disableNamespaces = false;

    static /* synthetic */ boolean access$3(XmlDocumentBuilder $0) {
        return $0.inDTD;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        ParentNode top = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String temp = new String(buf, offset, len);
            CDATASection section = (CDATASection)top.getLastChild();
            section.appendData(temp);
            return;
        }
        TextNode text = this.document.newText(buf, offset, len);
        try {
            top.appendChild(text);
            top.doneChild(text, this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public Locale chooseLocale(String[] languages) throws SAXException {
        Locale l = XmlDocument.catalog.chooseLocale(languages);
        if (l != null) {
            this.setLocale(l);
        }
        return l;
    }

    public void comment(String text) throws SAXException {
        if (this.ignoringLexicalInfo || this.inDTD) {
            return;
        }
        Comment comment = this.document.createComment(text);
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            top.appendChild(comment);
            top.doneChild((NodeEx)((Object)comment), this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public XmlDocument createDocument() {
        XmlDocument retval = new XmlDocument();
        if (this.factory != null) {
            retval.setElementFactory(this.factory);
        }
        return retval;
    }

    public void endCDATA() throws SAXException {
        if (!this.inCDataSection) {
            return;
        }
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = false;
            top.doneChild((NodeEx)top.getLastChild(), this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public void endDocument() throws SAXException {
        if (this.topOfStack != 0) {
            throw new IllegalStateException(this.getMessage("XDB-000"));
        }
        this.document.doneParse(this.context);
        this.document.trimToSize();
    }

    public void endElement(String tag) throws SAXException {
        ElementNode e = (ElementNode)this.elementStack[this.topOfStack];
        this.elementStack[this.topOfStack--] = null;
        if (!tag.equals(e.getTagName())) {
            this.fatal(new SAXParseException(this.getMessage("XDB-009", new Object[]{tag, e.getTagName()}), this.locator));
        }
        try {
            e.doneParse(this.context);
            e.reduceWaste();
            this.elementStack[this.topOfStack].doneChild(e, this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public void endParsedEntity(String name, boolean included) throws SAXException {
        ParentNode entity = this.elementStack[this.topOfStack];
        if (!(entity instanceof EntityReference)) {
            return;
        }
        entity.setReadonly(true);
        this.elementStack[this.topOfStack--] = null;
        if (!name.equals(entity.getNodeName())) {
            this.fatal(new SAXParseException(this.getMessage("XDB-011", new Object[]{name, entity.getNodeName()}), this.locator));
        }
        try {
            this.elementStack[this.topOfStack].doneChild(entity, this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    private void error(SAXParseException err) throws SAXException {
        if (this.parser == null) {
            throw err;
        }
        this.parser.getErrorHandler().error(err);
    }

    private void fatal(SAXParseException err) throws SAXException {
        if (this.parser != null) {
            this.parser.getErrorHandler().fatalError(err);
        }
        throw err;
    }

    public boolean getDisableNamespaces() {
        return this.disableNamespaces;
    }

    public XmlDocument getDocument() {
        return this.document;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public Locale getLocale() {
        if (this.parser != null) {
            return this.parser.getLocale();
        }
        return this.locale;
    }

    String getMessage(String messageId) {
        return this.getMessage(messageId, null);
    }

    String getMessage(String messageId, Object[] parameters) {
        if (this.locale == null) {
            this.getLocale();
        }
        return XmlDocument.catalog.getMessage(this.locale, messageId, parameters);
    }

    private String getNamespaceURI(String prefix) {
        if ("xml".equals(prefix)) {
            return xmlURI;
        }
        if ("xmlns".equals(prefix)) {
            return null;
        }
        return this.elementStack[this.topOfStack].getInheritedAttribute("xmlns:" + prefix);
    }

    public Parser getParser() {
        return this.parser;
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        if (this.ignoringLexicalInfo) {
            return;
        }
        ParentNode top = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String temp = new String(buf, offset, len);
            CDATASection section = (CDATASection)top.getLastChild();
            section.appendData(temp);
            return;
        }
        TextNode text = this.document.newText(buf, offset, len);
        try {
            top.appendChild(text);
            top.doneChild(text, this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public boolean isIgnoringLexicalInfo() {
        return this.ignoringLexicalInfo;
    }

    public void processingInstruction(String name, String instruction) throws SAXException {
        if (!this.disableNamespaces && name.indexOf(58) != -1) {
            this.error(new SAXParseException(this.getMessage("XDB-010"), this.locator));
        }
        if (this.inDTD) {
            return;
        }
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            PINode pi = (PINode)this.document.createProcessingInstruction(name, instruction);
            top.appendChild(pi);
            top.doneChild(pi, this.context);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public void setDisableNamespaces(boolean value) {
        this.disableNamespaces = value;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public final void setElementFactory(ElementFactory factory) {
        this.factory = factory;
    }

    public void setIgnoringLexicalInfo(boolean value) {
        this.ignoringLexicalInfo = value;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.parser != null) {
            this.parser.setLocale(locale);
        }
        this.locale = locale;
    }

    public void setParser(org.xml.sax.Parser p) {
        p.setDocumentHandler(this);
        if (p instanceof Parser) {
            this.parser = (Parser)p;
            this.parser.setDTDHandler(new DtdListener());
        } else {
            this.parser = null;
        }
    }

    public void startCDATA() throws SAXException {
        if (this.ignoringLexicalInfo) {
            return;
        }
        CDATASection text = this.document.createCDATASection("");
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = true;
            top.appendChild(text);
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
    }

    public void startDocument() throws SAXException {
        this.document = this.createDocument();
        if (this.locator != null) {
            this.document.setSystemId(this.locator.getSystemId());
        }
        this.elementStack = new ParentNode[200];
        this.topOfStack = 0;
        this.elementStack[this.topOfStack] = this.document;
        this.inDTD = false;
        this.document.startParse(this.context);
    }

    public void startElement(String tag, AttributeList attributes) throws SAXException {
        int length;
        AttributeSet attrs = null;
        ElementNode e = null;
        int n = length = attributes == null ? 0 : attributes.getLength();
        if (length != 0) {
            try {
                if (!this.disableNamespaces) {
                    int i = 0;
                    while (i < length) {
                        String type = attributes.getType(i);
                        if (!"CDATA".equals(type) && !type.startsWith("NMTOKEN") && tag.indexOf(58) != -1) {
                            this.error(new SAXParseException(this.getMessage("XDB-001", new Object[]{attributes.getName(i)}), this.locator));
                        }
                        ++i;
                    }
                }
                attrs = new AttributeSet(attributes);
            }
            catch (DOMException ex) {
                this.fatal(new SAXParseException(this.getMessage("XDB-002", new Object[]{ex.getMessage()}), this.locator, ex));
            }
        }
        try {
            if (this.disableNamespaces) {
                e = (ElementNode)this.document.createElementEx(tag);
            } else {
                int index = tag.indexOf(58);
                String attribute = "xmlns";
                String namespace = "";
                String localPart = tag;
                if (index != -1) {
                    attribute = "xmlns:" + tag.substring(0, index);
                    localPart = tag.substring(index + 1);
                    if (tag.lastIndexOf(58) != index) {
                        this.error(new SAXParseException(this.getMessage("XDB-003", new Object[]{tag}), this.locator));
                    }
                }
                if (attrs != null) {
                    namespace = attrs.getValue(attribute);
                }
                if ("".equals(namespace)) {
                    namespace = this.elementStack[this.topOfStack].getInheritedAttribute(attribute);
                }
                e = (ElementNode)this.document.createElementEx(namespace, localPart);
                if (localPart != tag) {
                    e.setTag(tag);
                }
            }
        }
        catch (DOMException ex) {
            this.fatal(new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex));
        }
        if (attributes != null && attributes instanceof AttributeListEx) {
            e.setIdAttributeName(((AttributeListEx)attributes).getIdAttributeName());
        }
        if (length != 0) {
            e.setAttributes(attrs);
        }
        this.elementStack[this.topOfStack++].appendChild(e);
        this.elementStack[this.topOfStack] = e;
        e.startParse(this.context);
        if (!this.disableNamespaces) {
            String prefix;
            int index = tag.indexOf(58);
            if (index > 0 && this.getNamespaceURI(prefix = tag.substring(0, index)) == null) {
                this.error(new SAXParseException(this.getMessage("XDB-005", new Object[]{prefix}), this.locator));
            }
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    String name = attrs.item(i).getNodeName();
                    index = name.indexOf(58);
                    if (index > 0 && !"xmlns".equals(prefix = name.substring(0, index))) {
                        String uri = this.getNamespaceURI(prefix);
                        if (uri == null) {
                            this.error(new SAXParseException(this.getMessage("XDB-006", new Object[]{prefix}), this.locator));
                        } else {
                            if (name.lastIndexOf(58) != index) {
                                this.error(new SAXParseException(this.getMessage("XDB-007", new Object[]{name}), this.locator));
                            }
                            name = name.substring(index + 1);
                            name = String.valueOf(uri) + '\uffff' + name;
                            if (this.attrTmp.contains(name)) {
                                this.error(new SAXParseException(this.getMessage("XDB-008", new Object[]{attrs.item(i).getNodeName()}), this.locator));
                            } else {
                                this.attrTmp.addElement(name);
                            }
                        }
                    }
                    ++i;
                }
                this.attrTmp.setSize(0);
            }
        }
    }

    public void startParsedEntity(String name) throws SAXException {
        if (this.ignoringLexicalInfo) {
            return;
        }
        EntityReference e = this.document.createEntityReference(name);
        this.elementStack[this.topOfStack++].appendChild(e);
        this.elementStack[this.topOfStack] = (ParentNode)((Object)e);
    }

    class ParseContextImpl
    implements ParseContext {
        ParseContextImpl() {
        }

        public ErrorHandler getErrorHandler() {
            return XmlDocumentBuilder.this.parser != null ? XmlDocumentBuilder.this.parser.getErrorHandler() : null;
        }

        public Locale getLocale() {
            return XmlDocumentBuilder.this.getLocale();
        }

        public Locator getLocator() {
            return XmlDocumentBuilder.this.locator;
        }
    }

    class DtdListener
    implements DtdEventListener {
        private Doctype doctype;
        private String publicId;
        private String systemId;
        private String internalSubset;

        DtdListener() {
        }

        public void endDtd() {
            this.doctype.setPrintInfo(this.publicId, this.systemId, this.internalSubset);
            XmlDocumentBuilder.this.document.appendChild(this.doctype);
            XmlDocumentBuilder.this.inDTD = false;
        }

        public void externalDtdDecl(String p, String s) throws SAXException {
            this.publicId = p;
            this.systemId = s;
        }

        public void externalEntityDecl(String n, String p, String s) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && n.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-012"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addEntityNode(n, p, s, null);
        }

        public void internalDtdDecl(String s) throws SAXException {
            this.internalSubset = s;
        }

        public void internalEntityDecl(String n, String v) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && n.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-012"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addEntityNode(n, v);
        }

        public void notationDecl(String n, String p, String s) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && n.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-013"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addNotation(n, p, s);
        }

        public void startDtd(String root) {
            this.doctype = XmlDocumentBuilder.this.document.createDoctype(root);
            XmlDocumentBuilder.this.inDTD = true;
        }

        public void unparsedEntityDecl(String n, String p, String s, String t) throws SAXException {
            if (!XmlDocumentBuilder.this.disableNamespaces && n.indexOf(58) != -1) {
                XmlDocumentBuilder.this.error(new SAXParseException(XmlDocumentBuilder.this.getMessage("XDB-012"), XmlDocumentBuilder.this.locator));
            }
            this.doctype.addEntityNode(n, p, s, t);
        }
    }
}

