/* This file contains hes_getpwnam, for retrieving passwd information about
 * a user.
 *
 * For copying and distribution information, see the file <mit-copyright.h>
 *
 * Original version by Steve Dyer, IBM/Project Athena.
 *
 *	$Author: ghudson $
 *	$Source: /afs/sipb/project/sipb-athena/src/hesiod/RCS/hespwnam.c,v $
 *	$Athena: hespwnam.c,v 1.4 88/08/07 21:52:51 treese Locked $
 */

#include "mit-copyright.h"

#ifndef lint
static char rcsid_pwnam_c[] = "$Header: /afs/sipb/project/sipb-athena/src/hesiod/RCS/hespwnam.c,v 1.4 1996/06/01 18:46:32 ghudson Exp $";
#endif
#include <stdio.h>
#include <pwd.h>
#include <string.h>
#include <netdb.h>
#include "hesiod.h"

static struct passwd pw_entry;
static char buf[256];

static char *_NextPWField();    /* For later definition in file */

extern int Hes_Errno;

static int
hes_getpwcommon(arg, which, entry, buf, bufsize)
	char *arg;
	int which;	/* 0=hes_getpwnam, 1=hes_getpwuid */
	struct passwd *entry;
	char *buf;
	int bufsize;
{
	register char *p;
	char *pp[2];
	int status;

	status = hes_resolve_r(arg, which ? "uid" : "passwd", pp, 2);
	if (status != HES_ER_OK)
		return(status);
	if (*pp == NULL)
		return(HES_ER_INVAL);
	/* choose only the first response (only 1 expected) */
	if ((int) strlen(pp[0]) > bufsize - 1) {
		free(pp[0]);
		return(HES_ER_RANGE);
	}
	(void) strcpy(buf, pp[0]);
	free(pp[0]);
	p = buf;
	entry->pw_name = p;
	p = _NextPWField(p);
	entry->pw_passwd = p;
	p = _NextPWField(p);
	entry->pw_uid = atoi(p);
	p = _NextPWField(p);
	entry->pw_gid = atoi(p);
#if (!defined(_AIX) || (AIXV < 31)) && !defined(sun) && !defined(linux) && !defined(__NetBSD__) && !defined(sgi)
	entry->pw_quota = 0;
#if defined(_AIX) && (AIXV < 31)
	entry->pw_age =
#endif
	entry->pw_comment = "";
#endif
	p = _NextPWField(p);
	entry->pw_gecos = p;
	p = _NextPWField(p);
	entry->pw_dir = p;
	p = _NextPWField(p);
	entry->pw_shell = p;
	while (*p && *p != '\n')
		p++;
	*p = '\0';
	return(HES_ER_OK);
}

/* Move the pointer forward to the next colon-separated field in the
 * password entry.
 */

static char *
_NextPWField(ptr)
char *ptr;
{
	while (*ptr && *ptr != '\n' && *ptr != ':')
		ptr++;
	if (*ptr)
		*ptr++ = '\0';
	return(ptr);
}

struct passwd *
hes_getpwnam(nam)
	char *nam;
{
	int status;

	hes_init();
	status = hes_getpwcommon(nam, 0, &pw_entry, buf, sizeof(buf));
	if (status == HES_ER_OK) {
		return(&pw_entry);
	} else {
		Hes_Errno = status;
		return(NULL);
	}
}

struct passwd *
hes_getpwuid(uid)
	int uid;
{
	char uidstr[16];
	int status;

	hes_init();
	sprintf(uidstr, "%d", uid);
	status = hes_getpwcommon(uidstr, 1, &pw_entry, buf, sizeof(buf));
	if (status == HES_ER_OK) {
		return(&pw_entry);
	} else {
		Hes_Errno = status;
		return(NULL);
	}
}

int
hes_getpwnam_r(nam, entry, buf, bufsize)
	char *nam;
	struct passwd *entry;
	char *buf;
	int bufsize;
{
	return hes_getpwcommon(nam, 0, entry, buf, bufsize);
}

int
hes_getpwuid_r(uid, entry, buf, bufsize)
	int uid;
	struct passwd *entry;
	char *buf;
	int bufsize;
{
	char uidstr[16];

	sprintf(uidstr, "%d", uid);
	return hes_getpwcommon(uidstr, 1, entry, buf, bufsize);
}

