# Copyright (c) 1995 by the Student Information Processing Board
# 	  of the Massachusetts Institute of Technology
#  
# Permission to use, copy, modify, and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation,
# and that the names of M.I.T. and the M.I.T. S.I.P.B. not be
# used in advertising or publicity pertaining to distribution
# of the software without specific, written prior permission.
# M.I.T. and the M.I.T. S.I.P.B. make no representations about
# the suitability of this software for any purpose.  It is
# provided "as is" without express or implied warranty.
#
#	$Id: unpack.sh,v 1.4 1996/06/01 18:42:44 ghudson Exp $
#	$Source: /afs/sipb/project/sipb-athena/src/install/arch/i386_nbsd1/RCS/unpack.sh,v $

# /tmp/vars inputs:
#	kernel		path to kernel to install, usually /srvd/netbsd
#	systemdir	AFS directory containing system software
#	osrev		revision of the OS we're installing
#	installdir	installation directory for FTPing tarfiles

. /tmp/vars

echo ""
echo "Starting extraction.  This will take about 10 minutes from a dorm"
echo "machine, and at least 90 minutes from an ILG on the frame relay."

cd /hd
tar xzvf $systemdir/os.${osrev}.tar.gz | \
	awk '(NR%10==1) { printf "." } END { print "" }'

echo -n "Copying in Athena files..."
synctree -s /srvd -d /hd -a /srvd/install/athena.rconf

echo -n "Copying in default configuration files..."
synctree -s /srvd -d /hd -a /srvd/install/etc.rconf

echo ""
echo -n "Copying kernel... "
cp $kernel /hd/netbsd
echo "done."

echo -n "Making device nodes... "
chroot /mnt sh -c 'cd /dev; sh MAKEDEV all'
echo "done."

sync
