/*
 *	$Source: /afs/sipb/project/sipb-athena/kerberos/appl/bsd/RCS/rlogind.c,v $
 *	$Header: /afs/sipb/project/sipb-athena/kerberos/appl/bsd/RCS/rlogind.c,v 1.4 1995/07/31 05:47:11 ghudson Exp $
 */

#ifndef lint
static char *rcsid_rlogind_c = "$Header: /afs/sipb/project/sipb-athena/kerberos/appl/bsd/RCS/rlogind.c,v 1.4 1995/07/31 05:47:11 ghudson Exp $";
#endif	lint

/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)rlogind.c	5.17 (Berkeley) 8/31/88";
#endif /* not lint */

/*
 * remote login server:
 *	remuser\0
 *	locuser\0
 *	terminal info\0
 *	data
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#ifdef NEED_SYS_FCNTL_H
#include <sys/fcntl.h>
#endif
#ifdef USE_UNISTD_H
#include <unistd.h>
#endif
#ifdef __SCO__
#include <sys/unistd.h>
#endif

#include <netinet/in.h>

#include <errno.h>
#include <pwd.h>
#include <signal.h>
#ifndef POSIX
/* or perhaps POSIX? given termios, we probably shouldn't use sgtty... */
#include <sgtty.h>
#endif
#include <netdb.h>
#include <syslog.h>
#include <string.h>

#ifdef POSIX
#include <stdlib.h>
#include <termios.h>
#ifdef _AIX
#include <termio.h>
#endif
#endif
#ifdef __SCO__
/* for TIOCPKT_* */
#include <sys/spt.h>
/* for struct winsize */
#include <sys/stream.h>
#include <sys/ptem.h>
#endif

#ifdef solaris20
#include <sys/tty.h>
/* for TIOCKPKT_* */
#include <sys/ptyvar.h>
/* get FIONBIO from sys/filio.h, so what if it is a compatibility feature */
#include <sys/filio.h>
#define setpgrp(a,b) setpgrp()
#define getpgrp(a) getpgid(a)
/* for I_PUSH */
#include <sys/stropts.h>
#define STREAMS_PTYEM
#endif

#ifdef linux
#define setpgrp(a,b) setpgid(a,b) 
#define GETPGRP_ONEARG
#endif

#ifdef hpux
#include <sys/ptyio.h>
#define PFLAG "-p",
#else
#define PFLAG /**/
#endif

#ifdef sgi
/* for _getpty */
#include <unistd.h>
#define GETPGRP_ONEARG
#define setpgrp(a,b) setsid()
#endif

#ifdef KERBEROS
#include <sys/param.h>
#include <utmp.h>
#include <krb.h>
#include <kstream.h>

#ifndef LOGIN_PROGRAM
#define LOGIN_PROGRAM "/usr/athena/etc/login.krb"
#endif
#define	SECURE_MESSAGE	"This rlogin session is using DES encryption for all data transmissions.\r\n"
#define NMAX	sizeof(wtmp.ut_name)
struct utmp	wtmp;
char		lusername[NMAX+1];
char		term[64];
int 		Klogin, klogin, eklogin;
AUTH_DAT	*kdata;
KTEXT		ticket;
Key_schedule	schedule;
void		do_krb_login();
kstream		kstr = 0;
#endif

# ifndef TIOCPKT_WINDOW
# define TIOCPKT_WINDOW 0x80
# endif /* TIOCPKT_WINDOW */

extern	int errno;
int	reapchild();
struct	passwd *getpwnam();

static	int Pfd;

#if (defined(_AIX) && defined(i386)) || defined(ibm032) || (defined(vax) && !defined(ultrix)) || (defined(SunOS) && SunOS > 40) || defined(solaris20)
#define VHANG_FIRST
#endif

#if defined(ultrix)
#define VHANG_LAST		/* vhangup must occur on close, not open */
#endif


/* ARGSUSED */
main(argc, argv)
	int argc;
	char **argv;
{
	int on = 1, fromlen;
	struct sockaddr_in from;

#ifdef KERBEROS
	/*
	 * if the command name is klogind or Klogind or eklogind, the
	 * connection has 
	 * been made thru the Kerberos authentication port for rlogin.  The
	 * protocol is different, to provide the transmission for the
	 * ticket used for authentication.
	 *
	 * If the name of the program is "klogind", and the Kerberos 
	 * authentication fails, we will allow the user password access
	 * to this host.  If the program name is "Klogind", and the
	 * Kerberos authentication fails, we will NOT allow password access;
	 * this is for protection of the Kerberos server and other highly
	 * paranoid hosts.
	 *
	 * If the name of the program is "eklogind", all data passing over
	 * the network pipe are encrypted.
	 */
#ifdef NOENCRYPTION
	klogin = (!strcmp(*argv,"eklogind") ||
		  !strcmp(*argv,"klogind"));	/* pass -k flag to login */
#else
	eklogin = !strcmp(*argv,"eklogind");	/* pass -e flag to login */
	klogin = !strcmp(*argv,"klogind");	/* pass -k flag to login */
#endif
	Klogin = !strcmp(*argv,"Klogind");	/* pass -K flag to login */
	/* 
	 * if klogin, Klogin, and eklogin are zero (ie, the program name was
	 * probably rlogind instead), pass the -r flag to login
	 */

#ifndef LOG_AUTH /* 4.2 syslog */
#ifdef NOENCRYPTION
	openlog(klogin ? "klogind" : (Klogin ? "Klogind" : "rlogind"),
		LOG_PID);
#else /* !NOENCRYPTION */
	openlog(eklogin ? "eklogind" : (klogin ? "klogind" :
					(Klogin ? "Klogind" : "rlogind")),
		LOG_PID);
#endif /* NOENCRYPTION */
#else
#ifdef NOENCRYPTION
	openlog(klogin ? "klogind" : (Klogin ? "Klogind" : "rlogind"),
		LOG_PID | LOG_AUTH, LOG_AUTH);
#else /* !NOENCRYPTION */
	openlog(eklogin ? "eklogind" : (klogin ? "klogind" :
					(Klogin ? "Klogind" : "rlogind")),
		LOG_PID | LOG_AUTH, LOG_AUTH);
#endif /* NOENCRYPTION */
#endif /* 4.2 syslog */
#else
#ifndef LOG_AUTH /* 4.2 syslog */
	openlog("rlogind", LOG_PID);
#else
	openlog("rlogind", LOG_PID | LOG_AUTH, LOG_AUTH);
#endif /* 4.2 syslog */
#endif /* KERBEROS */
	fromlen = sizeof (from);
	if (getpeername(0, (struct sockaddr *)&from, &fromlen) < 0) {
		syslog(LOG_DEBUG, "getpeername failed: %m");
		fprintf(stderr, "%s: ", argv[0]);
		perror("getpeername");
		_exit(1);
	}
	if (setsockopt(0, SOL_SOCKET, SO_KEEPALIVE, &on, sizeof (on)) < 0) {
		syslog(LOG_WARNING, "setsockopt (SO_KEEPALIVE): %m");
	}
	doit(0, &from);
}

int	child;
int	cleanup();
int	netf;
char	*line;
extern	char	*inet_ntoa();

#ifdef NO_WINSIZE
struct winsize {
	unsigned short ws_row, ws_col;
	unsigned short ws_xpixel, ws_ypixel;
};
#endif
struct winsize win = { 0, 0, 0, 0 };


doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	int i, p, t, vfd, pid, on = 1;
	register struct hostent *hp;
	struct hostent hostent;
	char c;

	alarm(60);
	read(f, &c, 1);
	if (c != 0)
		exit(1);
	alarm(0);
	fromp->sin_port = ntohs((u_short)fromp->sin_port);
	hp = gethostbyaddr(&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);
	if (hp == 0) {
		/*
		 * Only the name is used below.
		 */
		hp = &hostent;
		hp->h_name = inet_ntoa(fromp->sin_addr);
	}
#ifdef KERBEROS
	/* Don't care about reserved port for kerberos logins */
#ifdef NOENCRYPTION
	if (fromp->sin_family != AF_INET ||
	    (!klogin && !Klogin &&
	     (fromp->sin_port >= IPPORT_RESERVED ||
	     fromp->sin_port < IPPORT_RESERVED/2)))
#else /* !NOENCRYPTION */
	if (fromp->sin_family != AF_INET ||
	    (!klogin && !Klogin && !eklogin &&
	     (fromp->sin_port >= IPPORT_RESERVED ||
	     fromp->sin_port < IPPORT_RESERVED/2)))
#endif /* NOENCRYPTION */
#else /* !KERBEROS */
	if (fromp->sin_family != AF_INET ||
	    fromp->sin_port >= IPPORT_RESERVED ||
	    fromp->sin_port < IPPORT_RESERVED/2)
#endif /* KERBEROS */
		fatal(f, "Permission denied");
#if defined(KERBEROS) && !defined(NOENCRYPTION)
	/*
	 * If encrypting, we need to respond here, since we have to send
	 * the mutual authentication stuff before the response
	 */
	if (eklogin)
	    do_krb_login(f, hp->h_name);
	else
	  {
	    kstr = kstream_create_from_fd (0, 0, 0);
	    kstream_set_buffer_mode (kstr, 0);
	  }
#endif /* KERBEROS */
	write(f, "", 1);
#if defined(_AIX) && defined(_IBMR2)
	if ((p = open("/dev/ptc", O_RDWR)) >= 0) {
		line = ttyname(p);
		goto gotpty;
	}
#else
#ifdef sgi
	line = _getpty(&p, O_RDWR, 0600, 1); /* mode 0600, don't fork */
	if (line) goto gotpty;
#else
#ifdef STREAMS_PTYEM
	/* from pts(7) */
	if ((p = open("/dev/ptmx", O_RDWR)) >= 0) {
		if (!grantpt(p)) {
			if (!unlockpt(p)) {
				if (line = ptsname(p)) {
					goto gotpty;
				}
			}
		}
	}
#else
	for (c = 'p'; c <= 'z'; c++) {
		struct stat stb;
		static char ptybuf[] = "/dev/ptyXX";
		line = ptybuf;
		line[strlen("/dev/pty")] = c;
		line[strlen("/dev/ptyp")] = '0';
		if (stat(line, &stb) < 0)
			break;
		for (i = 0; i < 16; i++) {
 			line[sizeof("/dev/ptyp") - 1] = "0123456789abcdef"[i];
 			p = open(line, O_RDWR);
			if (p > 0)
				goto gotpty;
		}
	}
#endif /* !STREAMS_PTYEM */
#endif /* !sgi */
#endif /* !AIX3.1 */
	fatal(f, "Out of ptys");
	/*NOTREACHED*/
gotpty:
	Pfd = p;
#ifndef solaris20
	(void) ioctl(p, TIOCSWINSZ, &win);
#endif
	netf = f;
#if !defined(_AIX) && !defined(_IBMR2)
#ifndef STREAMS_PTYEM
	line[strlen("/dev/")] = 't';
#endif
#endif
#ifdef VHANG_FIRST
	vfd = open(line, O_RDWR);
 	if (vfd < 0)
 		fatalperror(vfd, line);
 	if (fchmod(vfd, 0))
 		fatalperror(vfd, line);
	/*
	 * On some systems you have to revoke tty access on close or
	 * you may lose access yourself.
	 */
 	(void)signal(SIGHUP, SIG_IGN);
#if defined(_AIX) && defined(i386)
	_vhangup();
#else
 	vhangup();
#endif
#endif /* VHANG_FIRST */
 	(void)signal(SIGHUP, SIG_DFL);
 	t = open(line, O_RDWR);
#ifdef VHANG_FIRST
#ifndef VHANG_NO_CLOSE
	(void) close(vfd);
#endif
#endif /* VHANG_FIRST */
 	if (t < 0)
 		fatalperror(f, line);
#ifdef STREAMS_PTYEM
	/* from pts(7) */
	if(ioctl(t, I_PUSH, "ptem") < 0)	/* push ptem */
		fatalperror(f, "pushing ptem streams module");
	if(ioctl(t, I_PUSH, "ldterm") < 0)	/* push ldterm */
		fatalperror(f, "pushing ldterm streams module");
	(void) ioctl(p, TIOCSWINSZ, &win);
#endif
#ifdef POSIX
	{
		struct termios new_termio;

		tcgetattr(t,&new_termio);
		new_termio.c_lflag &=  ~(ICANON|ECHO|ISIG|IEXTEN);
		/* so that login can read the authenticator */
		new_termio.c_iflag &= ~(IXON|IXANY|BRKINT|INLCR|ICRNL|ISTRIP);
		/* new_termio.c_iflag = 0; */
		/* new_termio.c_oflag = 0; */
		new_termio.c_cc[VMIN] = 1;
		new_termio.c_cc[VTIME] = 0;
		tcsetattr(t,TCSANOW,&new_termio);
	}
#else
 	{
 		struct sgttyb b;
 
 		(void)ioctl(t, TIOCGETP, &b);
 		b.sg_flags = RAW|ANYP;
 		(void)ioctl(t, TIOCSETP, &b);
	}
#endif
#ifdef DEBUG
	{
		int tt = open("/dev/tty", O_RDWR);
		if (tt > 0) {
		(void) ioctl(tt, TIOCNOTTY, 0);
		(void) close(tt);
	  }
	}
#endif
#ifdef POSIX
	setsid();
#endif
#if defined(__386BSD__) || defined(__NetBSD__)
        if (ioctl(t, TIOCSCTTY, (char *)NULL) == -1)
		fatalperror(f, "TIOCSCTTY", errno);
#endif
	t = open(line, O_RDWR);
	if (t < 0)
		fatalperror(f, line, errno);
#if defined(POSIX) && !defined(ultrix)
	{
		struct termios new_termio;

		tcgetattr(t,&new_termio);
		new_termio.c_lflag &=  ~(ICANON|ECHO|ISIG);
		/* so that login can read the authenticator */
		new_termio.c_iflag &= ~(IXON|IXANY|BRKINT|INLCR|ICRNL|ISTRIP);
		/* new_termio.c_iflag = 0; */
		/* new_termio.c_oflag = 0; */
		new_termio.c_cc[VMIN] = 1;
		new_termio.c_cc[VTIME] = 0;
		tcsetattr(t,TCSANOW,&new_termio);
	}
#else
	{
		struct sgttyb b;
		gtty(t, &b); b.sg_flags = RAW|ANYP; stty(t, &b);
	}
#endif
	pid = fork();
	if (pid < 0)
		fatalperror(f, "", errno);
	if (pid == 0) {
		close(f), close(p);
		dup2(t, 0); dup2(t, 1); dup2(t, 2);
		if (t > 2)
		    close(t);

		/* Under Ultrix 3.0, the pgrp of the slave pty terminal
		 needs to be set explicitly.  Why rlogind works at all
		 without this on 4.3BSD is a mystery.
		 It seems to work fine on 4.3BSD with this code enabled.
		 */
	        /* On solaris, at least, the pgrp is already correct... */
#ifdef GETPGRP_ONEARG
		pid = getpgrp();
#else
		pid = getpgrp(getpid());
#endif
#if defined(POSIX) || defined(hpux)
		/* Solaris is not the only POSIX platform.. */
		/* we've already done setsid above. Just do tcsetpgrp here. */
		tcsetpgrp(0, pid); 
#else
		ioctl(0, TIOCSPGRP, &pid);
#endif /* defined(POSIX)... */
#ifdef KERBEROS
		if (klogin) {
			execl(LOGIN_PROGRAM, "login", PFLAG "-k", hp->h_name, 0);
		} else if (Klogin) {
			execl(LOGIN_PROGRAM, "login", PFLAG "-K", hp->h_name, 0);
#ifndef NOENCRYPTION
		} else if (eklogin) {
		    struct passwd *pw;
		    pw = getpwnam(lusername);
		    if (pw && !pw->pw_uid)
			syslog(LOG_INFO, "ROOT LOGIN (krb) from %s, %s.%s@%s.",
			       hp->h_name, kdata->pname, kdata->pinst,
			       kdata->prealm);
		    execl(LOGIN_PROGRAM, "login", PFLAG "-e", hp->h_name,
			  lusername, 0);
#endif
		} else {
			execl(LOGIN_PROGRAM, "login", PFLAG "-r", hp->h_name, 0);
		}
		fatalperror(2, LOGIN_PROGRAM, errno);
#else
		execl("/bin/login", "login", PFLAG "-r", hp->h_name, 0);
		fatalperror(2, "/bin/login", errno);
#endif /* KERBEROS */
		/*NOTREACHED*/
	}
	close(t);

#if defined(KERBEROS) && !defined(NOENCRYPTION)
	if (eklogin)
	    kstream_write (kstr, SECURE_MESSAGE, sizeof(SECURE_MESSAGE)-1);
	else
	/*
	 * if encrypting, don't turn on NBIO, else the read/write routines
	 * will fail to work properly
	 */
#endif /* KERBEROS && !NOENCRYPTION */
	ioctl(f, FIONBIO, &on);
	ioctl(p, FIONBIO, &on);
	ioctl(p, TIOCPKT, &on);
#ifdef STREAMS_PTYEM
	ioctl(p, I_PUSH, "pckt");
#endif
	signal(SIGTSTP, SIG_IGN);
	signal(SIGCHLD, cleanup);
	setpgrp(0, 0);
#ifdef KERBEROS
	if (eklogin)
	    (void) write(p, term, strlen(term)+1); /* stuff term info down
						      to login */
#endif /* KERBEROS */
	protocol(f, p);
	signal(SIGCHLD, SIG_IGN);
	cleanup();
}

char	magic[2] = { 0377, 0377 };
char	oobdata[] = {TIOCPKT_WINDOW};

/*
 * Handle a "control" request (signaled by magic being present)
 * in the data stream.  For now, we are only willing to handle
 * window size changes.
 */
control(pty, cp, n)
	int pty;
	char *cp;
	int n;
{
	struct winsize w;

	if (n < 4+sizeof (w) || cp[2] != 's' || cp[3] != 's')
		return (0);
	oobdata[0] &= ~TIOCPKT_WINDOW;	/* we know he heard */
	memcpy((char *)&w, cp+4, sizeof(w));
	w.ws_row = ntohs(w.ws_row);
	w.ws_col = ntohs(w.ws_col);
	w.ws_xpixel = ntohs(w.ws_xpixel);
	w.ws_ypixel = ntohs(w.ws_ypixel);
	(void)ioctl(pty, TIOCSWINSZ, &w);
	return (4+sizeof (w));
}

/*
 * rlogin "protocol" machine.
 */
protocol(f, p)
	int f, p;
{
	char pibuf[1024], fibuf[1024], *pbp, *fbp;
	register pcc = 0, fcc = 0;
	int cc;
	char cntl;
	int fd_max = f;
	if (p > fd_max) fd_max = p;

	/*
	 * Must ignore SIGTTOU, otherwise we'll stop
	 * when we try and set slave pty's window shape
	 * (our controlling tty is the master pty).
	 */
	(void) signal(SIGTTOU, SIG_IGN);
	send(f, oobdata, 1, MSG_OOB);	/* indicate new rlogin */
	for (;;) {
		int n;
		fd_set ibits, obits, ebits;

		FD_ZERO(&ibits);
		FD_ZERO(&obits);
		FD_ZERO(&ebits);
		if (fcc)
			FD_SET(p, &obits);
		else
			FD_SET(f, &ibits);
		if (pcc >= 0)
			if (pcc)
				FD_SET(f, &obits);
			else
				FD_SET(p, &ibits);
		FD_SET(p, &ebits);
		if ((n = select(fd_max+1, &ibits, &obits, &ebits, 0)) < 0) {
			if (errno == EINTR)
				continue;
			fatalperror(f, "select");
		}
		if (n == 0) {
			/* shouldn't happen, since we're not timing out */
			sleep(5);
			continue;
		}
#define	pkcontrol(c)	((c)&(TIOCPKT_FLUSHWRITE|TIOCPKT_NOSTOP|TIOCPKT_DOSTOP))
		if (FD_ISSET(p, &ebits)) {
			cc = read(p, &cntl, 1);
			if (cc == 1 && pkcontrol(cntl)) {
				cntl |= oobdata[0];
				send(f, &cntl, 1, MSG_OOB);
				if (cntl & TIOCPKT_FLUSHWRITE) {
					pcc = 0;
					FD_CLR(p, &ibits);
				}
			}
		}
		if (FD_ISSET(f, &ibits)) {
			fcc = kstream_read (kstr, fibuf, sizeof (fibuf));
			if (fcc < 0 && errno == EWOULDBLOCK)
				fcc = 0;
			else {
				register char *cp;
				int left, n;

				if (fcc <= 0)
					break;
				fbp = fibuf;

			top:
				for (cp = fibuf; cp < fibuf+fcc-1; cp++)
					if (cp[0] == magic[0] &&
					    cp[1] == magic[1]) {
						left = fcc - (cp-fibuf);
						n = control(p, cp, left);
						if (n) {
							left -= n;
#ifdef MOVE_WITH_BCOPY
							if (left > 0)
								bcopy(cp+n, cp, left);
#else
							if (left > 0)
								memmove(cp, cp+n, left);
#endif
							fcc -= n;
							goto top; /* n^2 */
						}
					}
			}
		}

		if (FD_ISSET(p, &obits) && fcc > 0) {
			cc = write(p, fbp, fcc);
			if (cc > 0) {
				fcc -= cc;
				fbp += cc;
			}
		}

		if (FD_ISSET(p, &ibits)) {
#ifdef STREAMS_PTYEM
			struct strbuf databuf, ctlbuf;
			static char ctl_s[128];
			int flags = 0, st;
			databuf.buf=pibuf;
			databuf.maxlen=sizeof(pibuf);
			ctlbuf.buf=ctl_s;
			ctlbuf.maxlen=sizeof(ctl_s);

			st = getmsg(p, &ctlbuf, &databuf, &flags);
			/* since we're using 'pckt'... */
			if (st == (-1) && errno == EWOULDBLOCK)
				pcc = 0;
			else if (st == (-1))
				{ pcc = st; break; }
			if(ctlbuf.len != 1) {
			  /* then it's probably more data, if MOREDATA */
			  if (ctlbuf.len == (-1) && (databuf.len != (-1))) {
			    pbp = databuf.buf;
			    pcc = databuf.len;
			  } else {
			    /* the break causes an abort from here. */
			    pcc = 0; break;
			  }
			} else switch (ctlbuf.buf[0]) {
			case M_DATA:
			  pbp = databuf.buf;
			  pcc = databuf.len;
			  break;
			case M_PROTO:
			  /* hmm. */
			  pcc = 0;
			  break;
			}
#if 0
			if (ctlbuf.len != (-1)) {
				if (pkcontrol(ctl_s[0])) {
					ctl_s[0] |= oobdata[0];
					send(f, &ctl_s[0], 1, MSG_OOB);
				}
				pcc = 0;
			}
#endif
#else
			pcc = read(p, pibuf, sizeof (pibuf));
			pbp = pibuf;
			if (pcc < 0 && errno == EWOULDBLOCK)
				pcc = 0;
			else if (pcc <= 0)
				break;
			else if (pibuf[0] == 0)
				pbp++, pcc--;
			else {
				if (pkcontrol(pibuf[0])) {
					pibuf[0] |= oobdata[0];
					send(f, &pibuf[0], 1, MSG_OOB);
				}
				pcc = 0;
			}
#endif
		}
		if (FD_ISSET(f, &obits) && pcc > 0) {
			cc = kstream_write(kstr, pbp, pcc);
			if (cc < 0 && errno == EWOULDBLOCK) {
				/* also shouldn't happen */
				sleep(5);
				continue;
			}
			if (cc > 0) {
				pcc -= cc;
				pbp += cc;
			}
		}
	}
}

cleanup()
{
	char *p;

#ifdef solaris20
	p = line;
#else
	p = line + sizeof("/dev/") - 1;
#endif
	if (!logout(p))
		logwtmp(p, "", "");
	(void)chmod(line, 0666);
	(void)chown(line, 0, 0);
	*p = 'p';
	(void)chmod(line, 0666);
	(void)chown(line, 0, 0);
#ifdef VHANG_LAST
	close(Pfd);
	vhangup();
#endif
	shutdown(netf, 2);
	exit(1);
}

fatal(f, msg)
	int f;
	char *msg;
{
	char buf[BUFSIZ];

	buf[0] = '\01';		/* error indicator */
	(void) sprintf(buf + 1, "rlogind: %s.\r\n", msg);
	syslog(LOG_DEBUG, "fatal: %s %m",buf+1);
#ifdef KERBEROS
	if(kstr)
	  (void) kstream_write(kstr, buf, strlen(buf));
	else
#endif /* KERBEROS */
	(void) write(f, buf, strlen(buf));
	exit(1);
}

fatalperror(f, msg)
	int f;
	char *msg;
{
	char buf[BUFSIZ];

	(void) sprintf(buf, "%s: %s", msg, strerror(errno));
	fatal(f, buf);
}

#ifdef KERBEROS
void
do_krb_login(f, host)
	int f;
	char *host;
{
	int rc;
	struct sockaddr_in sin, faddr;
	char instance[INST_SZ], version[9];
	long authoptions = KOPT_DO_MUTUAL;

	if (getuid()) {
		fatal (f, "server not running as root?!  Login fails");
	}
	rc = sizeof(sin);
	if (getpeername(0, (struct sockaddr *)&sin, &rc)) {
		fatalperror (f, "can't get peer name");
	}
	rc = sizeof(faddr);
	if (getsockname(0, (struct sockaddr *)&faddr, &rc)) {
		fatalperror (f, "can't get socket name");
	}

	kdata = (AUTH_DAT *)malloc( sizeof(AUTH_DAT) );
	ticket = (KTEXT) malloc(sizeof(KTEXT_ST));

	strcpy(instance, "*");
	if (rc=krb_recvauth(authoptions, 0, ticket, "rcmd",
			    instance, &sin,
			    &faddr,
			    kdata, "", schedule, version)) {
		/* XXX Should spit back error msg from krb library.  */
		fatal (f, "Error decoding authenticator");
	}
	getstr(lusername, sizeof (lusername), "Local username");
	getstr(term, sizeof(term), "Terminal type");

	if (rc=kuserok(kdata,lusername)) {
		char buf[1024];
		sprintf (buf, "You are not allowed to log in as `%s'",
			 lusername);
		fatal (f, buf);
	}
	kstr = kstream_create_rlogin_from_fd (0, &schedule, &kdata->session);
	kstream_set_buffer_mode (kstr, 0);
}

getstr(buf, cnt, err)
	char *buf;
	int cnt;
	char *err;
{
	int ocnt = cnt;
	char *obuf = buf;
	char c;

	do {
		if (read(0, &c, 1) != 1) {
			exit(1);
		}
		if (--cnt < 0) {
			printf("%s '%.*s' too long, %d characters maximum.\r\n",
			       err, ocnt, obuf, ocnt-1);
			exit(1);
		}
		*buf++ = c;
	} while (c != 0);
}
#endif
