/*
 * $Source: /local/cvsfiles/kerberos/src/lib/des/dbg_prt.c,v $
 * $Author: eichin $
 *
 * Copyright 1988 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * Debugging print routines for DES library.
 *
 * Under U.S. law, this software may not be exported outside the US
 * without license from the U.S. Commerce department.
 *
 */

#ifdef DEBUG
#ifndef	lint
static char rcsid_module_c[] =
"$Header: /local/cvsfiles/kerberos/src/lib/des/dbg_prt.c,v 1.2 1993/02/27 04:56:05 eichin Exp $";
#endif	lint

#include <mit-copyright.h>

#include <stdio.h>
#include "des_internal.h"

#ifdef PC8086
/* The cc86 I/O library is busted.... */
static char const * const hex[256] = {
    "00", "01", "02", "03", "04", "05", "06", "07",
    "08", "09", "0a", "0b", "0c", "0d", "0e", "0f",
    "10", "11", "12", "13", "14", "15", "16", "17",
    "18", "19", "1a", "1b", "1c", "1d", "1e", "1f",
    "20", "21", "22", "23", "24", "25", "26", "27",
    "28", "29", "2a", "2b", "2c", "2d", "2e", "2f",
    "30", "31", "32", "33", "34", "35", "36", "37",
    "38", "39", "3a", "3b", "3c", "3d", "3e", "3f",
    "40", "41", "42", "43", "44", "45", "46", "47",
    "48", "49", "4a", "4b", "4c", "4d", "4e", "4f",
    "50", "51", "52", "53", "54", "55", "56", "57",
    "58", "59", "5a", "5b", "5c", "5d", "5e", "5f",
    "60", "61", "62", "63", "64", "65", "66", "67",
    "68", "69", "6a", "6b", "6c", "6d", "6e", "6f",
    "70", "71", "72", "73", "74", "75", "76", "77",
    "78", "79", "7a", "7b", "7c", "7d", "7e", "7f",
    "80", "81", "82", "83", "84", "85", "86", "87",
    "88", "89", "8a", "8b", "8c", "8d", "8e", "8f",
    "90", "91", "92", "93", "94", "95", "96", "97",
    "98", "99", "9a", "9b", "9c", "9d", "9e", "9f",
    "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7",
    "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af",
    "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7",
    "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf",
    "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7",
    "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf",
    "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
    "d8", "d9", "da", "db", "dc", "dd", "de", "df",
    "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7",
    "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef",
    "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7",
    "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"
};
#endif /* PC8086 */

void des_debug_print(string,i,ll,lh,rl,rh)
    char *string;
    unsigned i;
    unsigned ll,lh,rl,rh;
{
    printf("iter = %2d	",i);
    printf(string);
#ifdef PC8086
    printf("\t\tL1 = %s %s %s %s  R1 = %s %s %s %s\n",
	   hex[ll & 0xff], hex[(ll >> 8) & 0xff],
	   hex[lh & 0xff], hex[(lh >> 8) & 0xff],
	   hex[rl & 0xff], hex[(rl >> 8) & 0xff],
	   hex[rh & 0xff], hex[(rh >> 8) & 0xff]);
#else /* ! PC8086 */
    printf("\t\tL1 = %02x %02x %02x %02x  R1 = %02x %02x %02x %02x\n",
	   ll & 0xff, (ll >> 8) & 0xff,
	   lh & 0xff, (lh >> 8) & 0xff,
	   rl & 0xff, (rl >> 8) & 0xff,
	   rh & 0xff, (rh >> 8) & 0xff);
#endif
}
#endif
