#ifdef __NetBSD__
#define POSIX
#endif

#ifdef POSIX
#include <unistd.h>
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/time.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#if defined(ultrix) && defined(__STDC__)
/* Ultrix screwed this one */
extern char *index();
#endif

#ifdef POSIX
#include <fcntl.h>
#include <dirent.h>
typedef struct dirent my_dir;
#include <stdlib.h>
#include <malloc.h>
#else
#include <sys/dir.h>
typedef struct direct my_dir;
extern char *malloc(), *getenv();
#endif

#include <sys/param.h>

#ifndef MAXNAMLEN
#define MAXNAMLEN MAXPATHLEN
#endif

/* For now.... */
#define Const const

#if defined(ultrix) && !defined(__STDC__)
#undef Const
#define Const
#endif

/* Defines */

#define NSERVICES 4
#define S_ADD 0
#define S_DEL 1
#define S_SYNC 2
#define S_DEP 3

#define ADD_SUFFIX	".add"	
#define DEL_SUFFIX	".del"	
#define SYNC_SUFFIX	".sync"	
#define DEP_SUFFIX	".dep"	

#define DEF_RVDROOT "/srvd"
#define DEF_SRVDIR "/srvd/usr/athena/lib/update"
#define DEF_LOGFILE "/tmp/mkserv.log"

/* Structures */
struct file_header {
	char *version;
	char *platforms;
	char *options;
};

struct service {
	struct service *next;
	char *name;
	char *path;
	unsigned char configured;
	unsigned char exists[NSERVICES];
	unsigned char coreq;		/* store in .services file */
					/* coreq's are not */
	unsigned char del;		/* 1 implies should delete service */
	struct file_header fh[NSERVICES];
};

/* A generic serach path. "/" must be last character */
struct search_path {
	struct search_path *next;
	char *path;
};

struct cmd_service {
	struct cmd_service *next;
	int del;		/* 1 -> delete service */
	char *sname;
};

struct cmd_line {
	char *progname;
	int vflag;
	int update;
	int updatetest;
	int clean;
	int public;
	struct cmd_service *services;
};

struct local_env {
	char *srvdir;
	char *rvdroot;
	char *logfile;
	char *vers;
	char *mach;
	char *serverdir;
	char *configdir;
	char *confcng;
	char *services;
};

	
/* Prototypes */
#if defined(__STDC__) || defined(SABER)
#define PROTO_ANSI
#endif

#ifdef PROTO_ANSI
#define _AP(args) args
#else
#define _AP(args) ()
#endif

extern int walk_tree _AP((char *,int (*)(char *, struct stat *, char *, char *),char *,char *, int ));

extern char *find_in_string _AP((Const char *, char *));

#if !defined(sun) && !defined(__NetBSD__) && !defined(linux)
extern char *strdup _AP((char *));
#endif

extern int cmp_version _AP((char *, char *));

/* file.c */
extern int get_file_header _AP((char *, struct file_header *));

extern void free_header _AP((struct file_header *));

extern int copy_file _AP((char *, char *));

extern int copy_data _AP((int, int));

extern int tail_file _AP((char *, char *));

extern int append_file _AP((char *, char *));

/* services.c */
extern char *service_suffix _AP((int));

extern int get_service _AP((struct service *, struct search_path *));

extern int read_service_vno _AP((char *dir, struct service *serv));


extern int copy_service_file _AP((char *, char *, char *, char *));

extern void free_service _AP((struct service *));


extern void print_service_path _AP((struct search_path *));

extern int append_service_path _AP((struct search_path **, char *));

extern int read_services_file _AP((char *, struct service **));

extern struct service *find_service _AP((char *, struct service *));

extern struct service *allocate_service _AP((char *));

extern int config_services _AP((struct service *, struct local_env *));

extern int check_platform _AP((struct service *));

extern int write_out_services _AP((char *, struct service *));

/* os.c */
extern char *os_serverdir();

extern int os_create_serverdir _AP((char *));

extern int os_path_ok _AP((char *));

extern int os_attach _AP((char *path));

extern char *os_start_path _AP((struct local_env *));

extern char *os_platform();

extern char *os_versionfile();

extern void os_run_script _AP((struct service *, int));

extern char *os_switch_service _AP((char *, char *));

extern struct passwd *os_convert_hesiod_to_pwd _AP((char *));

extern int os_add_to_passwd _AP((struct passwd *));

extern int os_remove_passwd _AP((char *));

extern char *os_convert_service_to_inetd _AP((char *));

extern char *os_sitedir();

/* environment.c */
extern int insert_env _AP((char *, char *));

extern int setup_env _AP((struct local_env *));

/* cmds.c */
extern int parse_cmd _AP((int, char **, struct cmd_line *));


/* synctree.c */
extern int synctree_services 
	_AP((struct service *, struct local_env *, char *));

extern int synctree_final _AP((char *, char *));

/* cnfchg.c */
extern int change_configs _AP((char *));
