.\" $XConsortium: imake.man,v 1.18 92/09/14 11:53:38 rws Exp $
.TH IMAKE 1 "Release 5" "X Version 11"
.SH NAME
imake \- C preprocessor interface to the make utility
.SH SYNOPSIS
\fBimake\fP [ \fB\-D\fP\fIdefine\fP ] [ \fB\-I\fP\fIdir\fP ]
[ \fB\-T\fP\fItemplate\fP ]
[ \fB\-f\fP \fIfilename\fP ] [ \fB\-C\fP \fIfilename\fP ]
[ \fB\-s\fP \fIfilename\fP ] [ \fB\-e\fP ]
[ \fB\-v\fP ]
.SH DESCRIPTION
.I Imake
is used to 
generate \fIMakefiles\fP from a template, a set of \fIcpp\fP macro functions,
and a per-directory input file called an \fIImakefile\fP.  This allows machine
dependencies (such has compiler options, alternate command names, and special
\fImake\fP rules) to be kept separate from the descriptions of the
various items to be built.
.SH OPTIONS
The following command line options may be passed to \fIimake\fP:
.TP 8
.B \-D\fIdefine\fP
This option is passed directly to \fIcpp\fP.  It is typically used to set
directory-specific variables.  For example, the X Window System uses this
flag to set \fITOPDIR\fP to the name of the directory containing the top
of the core distribution and \fICURDIR\fP to the name of the current 
directory, relative to the top.
.TP 8
.B \-I\fIdirectory\fP
This option is passed directly to \fIcpp\fP.  It is typically used to 
indicate the directory in which the \fIimake\fP template and configuration
files may be found.
.TP 8
.B \-T\fItemplate\fP
This option specifies the name of the master template file (which is usually
located in the directory specified with \fI\-I\fP) used by \fIcpp\fP.
The default is \fIImake.tmpl\fP.
.TP 8
.B \-f \fIfilename\fP
This option specifies the name of the per-directory input file.  The default
is \fIImakefile\fP.
.TP 8
.B \-C \fIfilename\fP
This option specifies the name of the .c file that is constructed in the
current directory.  The default is \fIImakefile.c\fP.
.TP 8
.B \-s \fIfilename\fP
This option specifies the name of the \fImake\fP description file to be 
generated but \fImake\fP should not be invoked.
If the \fIfilename\fP is a dash (\-), the 
output is written to \fIstdout\fP.  The default is to generate, but
not execute, a \fIMakefile\fP.
.TP 8
.B \-e
This option indicates the \fIimake\fP should execute the generated
\fIMakefile\fP.  The default is to leave this to the user.
.TP 8
.B \-v
This option indicates that \fIimake\fP should print the \fIcpp\fP command line 
that it is using to generate the \fIMakefile\fP.
.SH "HOW IT WORKS"
\fIImake\fP invokes \fIcpp\fP with any \fI\-I\fP or \fI\-D\fP flags passed
on the command line and passes the name of a file containing the
following 3 lines:
.sp
.nf
		#define IMAKE_TEMPLATE "Imake.tmpl"
		#define INCLUDE_IMAKEFILE <Imakefile>
		#include IMAKE_TEMPLATE
.fi
.sp
where \fIImake.tmpl\fP and \fIImakefile\fP may be overridden by the 
\fI\-T\fP and \fI\-f\fP command options, respectively.
.PP
The IMAKE_TEMPLATE typically
reads in a file containing machine-dependent parameters 
(specified as \fIcpp\fP symbols), a site-specific parameters file,
a file defining variables,
a file
containing \fIcpp\fP macro functions for generating \fImake\fP rules, and
finally the \fIImakefile\fP (specified by INCLUDE_IMAKEFILE) in the current 
directory.  The \fIImakefile\fP uses the macro functions to indicate what
targets should be built; \fIimake\fP takes care of generating the appropriate
rules.
.PP
.I Imake
configuration files contain two types of variables, imake variables
and make variables.  The imake variables are interpreted by cpp when
.I imake
is run.  By convention they are mixed case.  The make variables are
written into the
.I Makefile
for later interpretation by
.I make.
By convention make variables are upper case.
.PP
The rules file (usually named \fIImake.rules\fP in the configuration
directory) contains a variety of \fIcpp\fP macro functions that are
configured according to the current platform.  \fIImake\fP replaces 
any occurrences of the string ``@@'' with a newline to allow macros that
generate more than one line of \fImake\fP rules.  
For example, the macro
.ta 1i 1.6i 5i
.nf

#define	program_target(program, objlist)	@@\e
program:	objlist		@@\e
	$(CC)  \-o  $@  objlist  $(LDFLAGS)

.fi
when called with
.I "program_target(foo, foo1.o  foo2.o)"
will expand to
.nf

foo:	foo1.o  foo2.o
	$(CC)  \-o  $@  foo1.o  foo2.o  $(LDFLAGS)

.fi
.PP
\fIImake\fP also replaces any occurrences of the word ``XCOMM'' with
the character ``#'' to permit placing comments in the Makefile without
causing ``invalid directive'' errors from the preprocessor.
.PP
On systems whose \fIcpp\fP reduces multiple tabs and spaces to a single
space, \fIimake\fP attempts to put back any necessary tabs (\fImake\fP is
very picky about the difference between tabs and spaces).  For this reason,
colons (:) in command lines must be preceded by a backslash (\\).
.SH "USE WITH THE X WINDOW SYSTEM"
The X Window System uses \fIimake\fP extensively, for both full builds within
the source tree and external software.  As mentioned above, two special
variables, \fITOPDIR\fP and \fICURDIR,\fP are set to make referencing files
using relative path names easier.  For example, the following command is
generated automatically to build the \fIMakefile\fP in the directory
\fIlib/X/\fP (relative to the top of the sources):
.sp
.nf
	%  ../.././config/imake  \-I../.././config  \\
		\-DTOPDIR=../../.   \-DCURDIR=./lib/X
.fi
.sp
When building X programs outside the source tree, a special symbol
\fIUseInstalled\fP is defined and \fITOPDIR\fP and
\fICURDIR\fP are omitted.  If the configuration files have been
properly installed, the script \fIxmkmf\fP(1) may be used.
.SH "INPUT FILES"
Here is a summary of the files read by
.I imake
as used by X.
The indentation shows what files include what other files.
.nf
.sp
.ta 3i
    Imake.tmpl	generic variables
        site.def	site-specific, BeforeVendorCF defined
        *.cf	machine-specific
            *Lib.rules	shared library rules
        site.def	site-specific, AfterVendorCF defined
        Project.tmpl	X-specific variables
            *Lib.tmpl	shared library variables
        Imake.rules	rules
        Imakefile
            Library.tmpl	library rules
            Server.tmpl	server rules
.fi
.LP
Note that \fIsite.def\fP gets included twice, once before the
\fI*.cf\fP file and once after.  Although most site customizations
should be specified after the \fI*.cf\fP file, some, such as the
choice of compiler, need to be specified before, because other
variable settings may depend on them.
.LP
The first time \fIsite.def\fP is included, the variable BeforeVendorCF
is defined, and the second time, the variable AfterVendorCF is
defined.  All code in \fIsite.def\fP should be inside an #ifdef for
one of these symbols.
.SH FILES
.ta 3i
Imakefile.c	temporary input file for cpp
.br
/tmp/Imf.XXXXXX	temporary Makefile for -s
.br
/tmp/IIf.XXXXXX	temporary Imakefile if specified Imakefile uses # comments
.br
/lib/cpp	default C preprocessor
.DT
.SH "SEE ALSO"
make(1), xmkmf(1)
.br
S. I. Feldman,
.I
Make \(em A Program for Maintaining Computer Programs
.SH "ENVIRONMENT VARIABLES"
The following environment variables may be set, however their use is not
recommended as they introduce dependencies that are not readily apparent
when \fIimake\fP is run:
.TP 5
.B IMAKEINCLUDE
If defined, this should be a valid include argument for the
C preprocessor.  E.g., ``\-I/usr/include/local''.
Actually, any valid
.I cpp
argument will work here.
.TP 5
.B IMAKECPP
If defined, this should be a valid path to a preprocessor program.
E.g. ``/usr/local/cpp''.
By default,
.I imake
will use /lib/cpp.
.TP 5
.B IMAKEMAKE
If defined, this should be a valid path to a make program,
such as ``/usr/local/make''.
By default,
.I imake
will use whatever
.I make
program is found using
.I execvp(3).
This variable is only used if the ``\-e'' option is specified.
.SH "AUTHOR"
Todd Brunhoff, Tektronix and MIT Project Athena; Jim Fulton, MIT X Consortium
