/*
 * This file is part of the OLC On-Line Consulting system.
 * It contains definitions for operating-system routines that don't
 * appear to be defined elsewhere, at least in BSD.
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /mit/sipb-athena/src/olc/include/olc/RCS/os.h,v $
 *	$Id: os.h,v 1.2 1996/06/02 03:11:01 svalente Exp $
 *	$Author: svalente $
 */

#ifndef __olc_os_h
#define __olc_os_h

#include <mit-copyright.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <stdio.h>
#include <fcntl.h>
#if defined(BSD) && (BSD <= 43)
#include <sys/dir.h>
#else
#include <unistd.h>
#include <dirent.h>
#endif

#if defined(_IBMR2) && defined(ZEPHYR)
/* Conflict in definitions between AIX's dir.h and zephyr.h for STAT; keep */
/* the Zephyr one */
#undef STAT
#endif /* IBM */

#if defined(__STDC__) || defined(HAS_ANSI_INCLUDES)
#include <stdlib.h>
#else
#ifdef __STDC__
# define P(s) s
#else
# define P(s) ()
#endif
char *ttyname P((int filedes ));
char *getenv P((char *name ));
void *malloc P((unsigned int));
void *realloc P((void *, unsigned int));
void *calloc P((unsigned int, unsigned int));

#undef P
#endif /* HAS_ANSI_INCLUDES */

#endif /* __olc_os_h */
