/**********************************************************************
 * document viewing module
 *
 * $Author: lwvanels $
 * $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/plaintext.c,v $
 * $Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/plaintext.c,v 1.2 91/01/04 12:20:34 lwvanels Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef lint
#ifndef SABER
static char rcsid_viewdoc_c[] = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/libmenu/RCS/plaintext.c,v 1.2 91/01/04 12:20:34 lwvanels Exp $";
#endif
#endif

#include <stdio.h>
#include <errno.h>
#include <memory.h>
#include <menu.h>
#define ATTACH_NOMAP 0
#define ATTACH_MAP   1

FILE *
doc_stream(e)
     MenuEntry *e;
{
  FILE *fp = NULL;
  char *filsys;
  int tried = 0;		/* 1 if already tried nomap attach */
  int triedm = 0;		/* 1 if already tried map attach */

  while (fp == NULL) {
    fp = fopen(field_value(e, FILE_LOCATION), "r");
    if (fp) break;
    
    switch(errno) {
    case ENOENT:		/* No such file or directory */
      filsys = field_value(e, FILESYSTEM);
      if (tried || *filsys == '\0' || olh_attach(filsys, ATTACH_NOMAP))
	return(NULL);
      tried = 1;
      break;
    case EACCES:		/* Permission denied */
      filsys = field_value(e, FILESYSTEM);
      if (triedm || *filsys == '\0' || olh_attach(filsys, ATTACH_MAP))
	return(NULL);
      triedm = 1;
      break;
    default:			/* nothing we can do */
      return(NULL);
    }
  }
  return(fp);
}

char *
doc_string(e)
     MenuEntry *e;
{
  FILE *fp;
  char *ret = NULL;
  char buf[BUFSIZ];
  int sret = 0, sbuf;

  fp = doc_stream(e);
  if (!fp) return(NULL);
  do {
    sbuf = fread(buf, sizeof(char), BUFSIZ, fp);
    if (ret) {
      ret = ResizeArray(char, ret, sret+sbuf);
    } else {
      ret = NewArray(char, sbuf);
    }
    if (!ret) {
      fclose(fp);
      return(NULL);
    }
    bcopy(buf, ret + sret, sbuf);
    sret += sbuf;
  } while (sbuf == BUFSIZ);
  fclose(fp);
  ret = ResizeArray(char, ret, sret+1);
  *(ret + sret) = '\0';
  return(ret);
}
