/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /source/athena/athena.bin/olh/motif/RCS/ButtonCB.c,v $
 *      $Id: ButtonCB.c,v 1.1 1992/05/01 17:08:29 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include "global.h"
#include "widget_num.h"
#include <Xm/Text.h>
#include <Xm/ToggleBG.h>

void
ButtonCB(widget, tag, callback_data)
     Widget widget;
     int tag;
     XmAnyCallbackStruct *callback_data;
{
  char *ptr;

  if ((tag >= HELP_BTN) && (tag <= HELP_BTN+n_hbuttons)) {
    help(widget, tag, callback_data);
    return;
  }

  switch(tag)
    {
    case QUIT_BTN:
      XtUnmapWidget(w[TOPLEVEL]);
      XFlush(XtDisplay(w[TOPLEVEL]));
      exit(0);

    case VIEW_BTN:
      view(0);
      break;

    case PREV_BTN:
      view(-1);
      break;

    case NEXT_BTN:
      view(1);
      break;

    case UP_BTN:
      up_menu();
      break;

    case KWD_UP_BTN:
      k_up_menu();
      break;

    case KWD_SEND_BTN:
      k_view_selected();
      break;

    case MENU_FORM:
      dunno(widget, tag, callback_data);
      break;

    case TEXT_CLOSE_BTN:
      XtUnmapWidget(w[TEXT_DLG]);
      break;

    case HIST_TOG:
      toggle(widget, tag);
      break;

    case TOP_BTN:
      menu_callback(widget, 0, callback_data);
      break;

    case VERSION_BTN:
      if ((ptr = GetDefault(XtDisplay(w[TOPLEVEL]), "Olh", "copyright"))
	  == NULL)
	ptr = "No copyright/version in resources.";
      show_message(ptr);
      break;

    case SUGGEST_BTN:
      MakeDialog(SUGGEST_DLG);
      XtMapWidget(w[SUGGEST_DLG]);
      _XmGrabTheFocus(w[SUGGEST_TEXT], NULL);
      break;
      
    case BUG_BTN:
      MakeDialog(SENDBUG_DLG);
      XtMapWidget(w[SENDBUG_DLG]);
      _XmGrabTheFocus(w[SENDBUG_TEXT], NULL);
      break;
      
    case INFO_CLOSE_BTN:
      File_ok(widget, INFO_DLG, callback_data);
      break;

    case COPY_OK_BTN:
      File_ok(widget, COPY_DLG, callback_data);
      break;

    case COPY_CLOSE_BTN:
      break;

    case KWD_BTN:
      if ((ptr = GetDefault(XtDisplay(w[TOPLEVEL]), "Olh",
			    "message.KeywordWait"))
	  == NULL)
	ptr = "Please wait; creating keyword list";
      show_message(ptr);
      MakeDialog(KWD_DLG);
      XtMapWidget(w[KWD_DLG]);
      _XmGrabTheFocus(w[KWD_TEXT], NULL);
      break;

    case KWD_CLOSE_BTN:
      XtUnmapWidget(w[KWD_DLG]);
      break;

#ifdef HIDDEN
    case USER_BKMK_BTN:
      MakeDialog(BKMK_DLG);
      XtManageChild(w[BKMK_DLG]);
      break;

    case BKMK_CLOSE_BTN:
      XtUnmanageChild(w[BKMK_DLG]);
      break;
#endif

    case SUGGEST_SEND_BTN:
      ptr = XmTextGetString(w[SUGGEST_TEXT]);
      mail(ptr, tag);
      XtFree(ptr);
      XmTextSetString(w[SUGGEST_TEXT], "");
      XtUnmapWidget(w[SUGGEST_DLG]);
      break;

    case SUGGEST_CLOSE_BTN:
      XmTextSetString(w[SUGGEST_TEXT], "");
      XtUnmapWidget(w[SUGGEST_DLG]);
      break;

    case SENDBUG_SEND_BTN:
      ptr = XmTextGetString(w[SENDBUG_TEXT]);
      mail(ptr, tag);
      XtFree(ptr);
      XmTextSetString(w[SENDBUG_TEXT], "");
      XtUnmapWidget(w[SENDBUG_DLG]);
      break;

    case SENDBUG_CLOSE_BTN:
      XmTextSetString(w[SENDBUG_TEXT], "");
      XtUnmapWidget(w[SENDBUG_DLG]);
      break;

    default:
      fprintf(stderr, "Button %d selected.\n", tag);
      break;
    }
}

void
toggleCB(widget, tag, callback_data)
     Widget widget;
     int tag;
     XmAnyCallbackStruct *callback_data;
{
  olh_res.use_viewers = !olh_res.use_viewers;
}
