/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /source/athena/athena.bin/olh/motif/RCS/GetDefault.c,v $
 *      $Id: GetDefault.c,v 1.1 1992/05/01 17:09:03 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include "global.h"

/*
 * GetDefault works just like XGetDefault, but this version allows you
 * to get resources with periods in them.
 */

char *GetDefault(dpy, prog, string)
     Display *dpy;		/* display for defaults. */
     char *prog;		/* Name of program. */
     char *string;		/* resource to get. */
{
  char temp[BUFSIZ], temp2[BUFSIZ];
  XrmString type;
  XrmValue result;
  char *progname;
  char *ptr, *ptr2;

  /*
   * strip path off of program name
   */
  progname = rindex (prog, '/');
  if (progname)
    progname++;
  else
    progname = prog;

  strcpy(temp, progname);
  strcat(temp, ".");
  strcat(temp, string);
  
  strcpy(temp2, "Program");

  ptr2 = temp;
  while ((ptr = index(ptr2, '.')) != NULL)
    {
      strcat(temp2, ".Name");
      ptr2 = ptr + 1;
    }

  XrmGetResource(XtDatabase(dpy), temp, temp2, &type, &result);

  return (result.addr);
}
