/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.bin/olh/motif/RCS/global.h,v $
 *      $Id: global.h,v 1.11 92/05/07 10:19:02 lwvanels Exp $
 *      $Author: lwvanels $
 */

#ifndef _GLOBAL_
#define _GLOBAL_

#include <stdio.h>

#include <Xm/Xm.h>
#include <Xm/ListP.h>

#include "MuMenu.h"
#include "menu.h"

typedef struct _OlhResources {
  Boolean use_viewers;
} OlhResources;

extern OlhResources olh_res;

extern char *program;
extern Widget W, w[];
extern Menu *menu[512];
extern short current[512];
extern short viewed[512];
extern Widget menu_btn[512];
extern short current_menu;
extern MenuEntry *top_entry;
extern char *top_pointer;
extern int n_hbuttons;

#define MOTIF_STRING(s)	  XmStringLtoRCreate((s), XmSTRING_DEFAULT_CHARSET)
#define	  CLEAR_MSG   show_message(" "); show_k_message(" ")

#endif /* _GLOBAL_ */
#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

/* ButtonCB.c */
void ButtonCB P((Widget widget , int tag ,
		 XmAnyCallbackStruct *callback_data ));
void toggleCB P((Widget widget, int tag, XmAnyCallbackStruct *callback_data));

/* Context.c */
long ConstructContext P((char *p ));

/* Cursor.c */
void SetCursor P((int wait ));

/* File.c */
void File P((Widget widget , int tag , XmAnyCallbackStruct *callback_data ));
void File_ok P((Widget widget , int tag ,
		XmAnyCallbackStruct *callback_data ));

/* GetDefault.c */
char *GetDefault P((Display *dpy , char *prog , char *string ));

/* Highlight.c */
int XmGetHighlight P((XmListWidget lw ));
void XmSetHighlight P((XmListWidget lw , int position ));
void XmDrawHighlight P((XmListWidget lw , int position , int on ));

/* MuMenu.c */
void MuRegisterMenuCallbacks P((MuCallbacksRec c [], int num ));
XtCallbackProc MuGetMenuCallback P((char *name ));
Widget MuCreateMenuBar P((Widget p , String name , Arg *args , int count ));
Widget MuCreateMenuPane P((Widget p , String name , Arg *args , int count ));
Widget MuCreateOptionMenu P((Widget p , String name ));
void MuOptionMenuSetSelectedItem P((Widget w , int n ));
int MuOptionMenuGetSelectedItem P((Widget w ));
void MuOptionMenuSetSelectedString P((Widget w , char *str ));
char *MuOptionMenuGetSelectedString P((Widget w ));

/* Scroll.c */
void ScrollList P((int widget_num , KeySym ks , XKeyEvent *event ));

/* XmListUtils.c */
void XmListGetSelectedPositions P((XmListWidget w , int **return_table ,
				   int *return_count ));
void XmListSetSelectedPositions P((XmListWidget w , int *items ,
				   int num_items ));
int XmListGetTopPos P((XmListWidget w ));
int XmListGetBottomPos P((XmListWidget w ));

/* callbacks.c */
void mail P((char *text , int bug_or_suggest ));
void menu_callback P((Widget widget , int tag ,
		      XmAnyCallbackStruct *callback_data ));
void view P((int num ));
void list_1_click P((Widget widget , caddr_t tag ,
		     XmListCallbackStruct *callback_data ));
void list_2_click P((Widget widget , caddr_t tag , 
		     XmListCallbackStruct *callback_data ));
void toggle P((Widget widget , int tag ));
void up_menu P((void ));
void show_message P((char *string ));
void show_k_message P((char *string ));
void dunno P((Widget widget , int tag , XmAnyCallbackStruct *callback_data ));
void ListExtra P((Widget widget , int widget_num , XKeyEvent *event ));

/* help.c */
void add_help_menus P((void ));
void help P((Widget widget , int tag , XmAnyCallbackStruct *callback_data ));

/* invoke.c */
void invoke P((int i ));
void viewFile P((char *text , char *name ));
void viewTextFile P((MenuEntry *e, char *name ));
void do_menu P((Menu *m ));

/* keywords.c */
void do_keyword_startup P((char *));
void setup_keyword_dialog P((void ));
void k_menu_callback P((Widget widget , int tag ,
			XmAnyCallbackStruct *callback_data ));
void k_do_menu P((Menu *m ));
void k_up_menu P((void ));
void k_view_selected P((void ));
void k_invoke P((int i ));
void k_entered P((Widget widget , int tag , 
		  XmAnyCallbackStruct *callback_data ));
void k_changed P((Widget widget , int tag , 
		  XmAnyCallbackStruct *callback_data ));

/* main.c */
void main P((int argc , char **argv ));
void WaitForExpose P((Widget w ));

/* menupath.c */
void init_menupath P((void ));
void add_to_menupath P((MenuEntry *e ));
void resize_menupath P((int size ));
void make_parents_menupath P((MenuEntry *e ));
long add_parent_to_menupath P((MenuEntry *e ));
long menupath_from_string P((char *text ));

/* visual.c */
void MakeInterface P((void ));
void MakeMessageLabel P((void ));
void MakeMenuForm P((void ));
void MakeHistForm P((void ));
void MakeTextView P((void ));
void MakeDialog P((int which ));

#undef P
