
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <X/Xlib.h>

#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) < (b) ? (a) : (b))
#define abs(a) ((a) < 0 ? -(a) : (a))
typedef enum _bool {FALSE,TRUE} Bool;

/* modified by RMS to use new XVideo library 6/10/87 */

#define SCOPE extern
#include "XVideo.h"

#undef FAILURE
#define FAILURE 0
#define VIDBACK 0

Window VideoWindow;
char *index();

main(argc, argv)
	int argc;
	char **argv;
{
	char *geom = NULL;
	char *display = NULL;
	Font font;
	FontInfo font_info; 
	XEvent event;
	int i;
	char *strind;
	char default_geom[20];
	OpaqueFrame	frame;
	int readfds = 0;
	int maxfds = 0;
	int prio = 1;
	int still = 0;
	int scale = 0;
	int update = 0;
	int win_w, win_h;  /* window height and width */
	struct timeval timeout;
	char msg[64];

	for (i = 1; i < argc; i++) {
		if (argv [i] [0] == '=') {
		        geom = argv[i];
		        continue;
		}
		strind = index(argv[i], ':');
		if(strind != NULL) {
		        display = argv[i];
			continue;
		}
		if (argv[i] [0] == '-') {
		    if (argv[i] [1] == 'f') {
			still = 1;
			continue;
		    }
		    if (argv[i] [1] == 's') {
			still = 1;
			scale = 1;
			continue;
		    }
		    if (argv[i] [1] == 'u') {
			update = atoi(argv[++i]);
			continue;
		    }
		    continue;
		}
		printf("illegal syntax\n");
		exit(1);
	}

	/*
	 * Open up the display.
	 */
	if (XOpenDisplay(display) == NULL) {
		fprintf(stderr, "%s: Can't open display '%s'\n",argv[0], XDisplayName(display));
		exit(1);
	}

	XSetVideoDisplay();
	if( !VideoDevice )
		perror("video: not on a Parallax display");

	/*
	 * Set up colors and pixmaps.
	 */

	/*
	 * Open the main window.
	 */
	{
	int min_width, min_height;
		sprintf (default_geom,
			 "%dx%d-0-0", 640,480);
		}
	frame.bdrwidth = 16;
	frame.border = XMakeTile(BlackPixel);
	frame.background = XMakeTile(VIDBACK);
	if (!still) 
	VideoWindow = XCreateVideo (
	"Live Video Window",
		argv[0],
		geom,
		default_geom,
		&frame,
		48,
		50);
	else if (!scale) VideoWindow = XCreateVideo (
	"Still Video Window",
		argv[0],
		geom,
		default_geom,
		&frame,
		48,
		50);
	else VideoWindow = XCreateVideo (
	"Scaled Still Video Window",
		argv[0],
		geom,
		default_geom,
		&frame,
		16,
		16);
	if (VideoWindow == FAILURE) {
		printf("Can't open video window");
		exit(1);
	}

	/*
	 * Select window exposure events to see if the contents of
	 * the window have been erased or altered.  Select unmap events so
	 * we can stop output when iconified.
	 */
	XSelectInput(VideoWindow, 
		ExposeWindow|ExposeRegion|ExposeCopy|UnmapWindow|
		  ButtonPressed);

	/*
	 * Map  video window to screen.
	 */
	XMapWindow(VideoWindow);
	/*
	 * set up for time-outs every 15 seconds, and also for
	 * wake-ups for each X call.
	 * the 15 second time-out serves 2 purposes.  It guarantees
	 * the video display will not time-out and turn off from
	 * disuse while video is running.  It also cleans up the
	 * video window if it had been obscured, and took a less
	 * then optimal approach to dividing it
	 */
	if (update == 0) {
	    if (!still) update = 5;
	    else update = 1000;
	}
	maxfds = dpyno() + 1;
	timeout.tv_sec=update;
	timeout.tv_usec=0;

	XSync(FALSE);

	while(1) {
	    if (XPending() != 0) {
		XNextEvent(&event);
		if (event.type == UnmapWindow) {
		    /* UnmapWindow events mean the window is
		     * not visible, so wait here for a new event 
		     */
		        XPeekEvent(&event);
			continue;
		}
		if (event.type == ButtonPressed) {
		    prio = (prio+1) & 3;
		    if (prio==0) ++prio;
		    printf("video priority = %d\n",prio);
	        }
		if (event.type == ExposeWindow) {
		     /* check for window resize */
		      XExposeWindowEvent *exp_event =
		      (XExposeWindowEvent *)&event;

		      win_w = exp_event->width;
		      win_h = exp_event->height;
		}
		if ((still) && (update>=1000)) {
		    if (!scale) {
			VLABEL("Still Video Window");
			XStillVideo(VideoWindow,0,0,0,0,640,482);
			}
		    else {
			sprintf(msg,"Scaled: %dx%d",ROUND_16(win_w),win_h);
			VLABEL(msg);
			XScaleVideo(VideoWindow,0,0,640,480,0,0,win_w,win_h);
			}
		    XFlush();
		}


/* start video with upper left corner of video in upper left corner of window */

	    }
	    if (!still) {
		sprintf(msg,"Live: priority %d",prio);
		VLABEL(msg);
		XStartVideo(VideoWindow,0,0,prio);
		XFlush();
	    }
	    if ((still) && (update<1000)) {
		if (!scale) {
			VLABEL("Still Video Window");
			XStillVideo(VideoWindow,0,0,0,0,640,482);
			}
		else {
			sprintf(msg,"Scaled: %dx%d",ROUND_16(win_w),win_h);
			VLABEL(msg);
			XScaleVideo(VideoWindow,0,0,640,480,0,0,win_w,win_h);
			}
		XFlush();
	    }

	    readfds = 1<<dpyno();
	    if (select(maxfds,&readfds,NULL,NULL,&timeout) == -1) {
		printf("Error in select\n");
		exit(1);
	    }
	}

}

