#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#include "defs.h"

extern Screen *screen_sets[Screen_sets];
extern make_tk_widget();

#define MATCH 0
#define IN 1
#define OUT 0

  static int
sort_events(ev, n)
	Timed_ev	ev[];
	int		n;
{
	int		g, i, j;
	Timed_ev	tmp;

printf("sort_events\n");

	for( g = n/2; g > 0; g /= 2)
	{
		for(i = g; i < n; i++)
		{
			for(j = i-g; j >= 0 &&
			    ev[j].pos > ev[j+g].pos; j -= g)
			{
				tmp = ev[j];
				ev[j] = ev[j+g];
				ev[j+g] = tmp;
			 }
		 }
	 }
}

  static int
make_event_chain_for( ele, timed_dimensions )
	Element  	*ele;
	int		timed_dimensions;
{
	static char	*func = "make_event_chain_for";
	Map		*m = ele->map;
	int		i, d, total;

printf("%s `%s', timed_dimensions `%d'\n",func,ele->name,timed_dimensions);

	for(total = 0; m; ++total) m = m->simple.next;
	total *= 2;  /* count how many events there are */
	ele->event_count = total;

printf("  with `%d' events\n",total);

	for(d = 0; d < MaxDims; ++d)
	{
		if((1 << d) & timed_dimensions)
		{
printf("  found a timed dim `%d'\n",d);
			ele->cur_event_pos[d] = -1;  /* init */
			if((ele->event[d] = (Timed_ev *) 
			   calloc (total, sizeof(Timed_ev))) == NULL)
			{
				printf("%s: failed calloc event list\n",func);
				exit(1);
	 		 }

			m = ele->map;
if(!m) printf("  !!! NO MAP for element `%s'\n", ele->name);
			for(i = 0; m; ++i)
			{
			    ele->event[d][i].type = IN;
			    ele->event[d][i].pos = m->simple.pos[InPoint][d];
			    ele->event[d][i].map = m;

			    ele->event[d][++i].type = OUT;
			    ele->event[d][i].pos = m->simple.pos[OutPoint][d];
			    ele->event[d][i].map = m;

printf("  map out `%d' vs `%d'\n",ele->event[d][i].pos,m->simple.pos[OutPoint][d]);

			    m = m->simple.next;
	 		 }
			sort_events( ele->event[d], total);
for( i=0;i<total;++i) printf("  %d",ele->event[d][i].pos);
printf("\n");
		 }
	}
}


resolve_names()
{
  char 		*funcname = "resolve_names";
  Screen 	*s;
  Element 	*ele, *tele;
  Package 	*pck, *tpck;
  Map		*m;
  int 		t, i;
  int		timed_dimensions;	/* bit mask */


printf("%s\n",funcname);

/*
*  Resolve Names
*
*  The routine goes through the list of packages and resolves the
*  names referenced by that package.  First it finds the packages in
*  the `unext' slot.  It creates closed loops of packages with home
*  packages flagged.
* 
*  Then it finds the window set listed in `screen_name'.
*  The windows have already been created by Makewindows() before coming
*  here.
*
*  Once it has the set of windows to work from, it starts down
*  the list of elements in the package.
*  For each element, it resolves the `next' name and finds the display
*  window for that element in the list of windows held by the parent
*  package.
*
*  If the element is a widget of some sort, then it goes down the list
*  of mappings to actually build the widgets and get the window pointers
*  for them.  Coming in, the data for the widget is held in the
*  `map->simple.w' slot, as a pointer to a struct of the appropriate type.
*/

	pck = first_package;

	while(pck != 0)
	{
		timed_dimensions = 0;  /* clear for each pack */
	        for(i = 0; i < MaxDims && pck->dimension[i]; ++i)
	        {
		        pck->position[i] = pck->dimension[i]->min;

			if( pck->dimension[i]->timed )
			{ 
		 	    (timed_dimensions |= (1 << i));
printf("  set dim[%d] timed, timed_dims = `%d'\n",i,timed_dimensions);
			 }
				
	         }

  		if(strlen(pck->nextname))
		{
    		    tpck = first_package;
    		    while(strcmp(pck->nextname, tpck->name) != MATCH)
      		    {
			  if((tpck = tpck->next) == 0)
	  		  {
	    		    printf("%s: can't match next: %s in package %s\n"
		   		,funcname, pck->nextname, pck->name);
	    		    exit(1);
	  		   }
      	 	     }
    		    pck->unext = tpck;
		    pck->unext->uprev = pck;
  		 }
		else				/* close loop */
		{
			for(tpck = pck; tpck->uprev; tpck = tpck->uprev);
			tpck->uprev = pck;
			pck->unext = tpck;
		 }
 

		if(strlen(pck->screen_name))
		{
  		   	for(i=0; i < Screen_sets; ++i)
			{
      				if(strcmp(pck->screen_name, 
					screen_sets[i]->name) == MATCH)
				{
      					break;
    				 }
			 }

			if(i < Screen_sets)
			{
  				pck->window = screen_sets[i];
			 }
    			else
			{
      		          	printf("%s: can't match screen named %s in package %s\n",funcname, pck->screen_name, pck->name);
      			  	exit(1);
    			 }
   			 
		 }
		else
		{
  			printf("%s: missing screen name in package %s\n"
				,funcname,pck->name);
  			exit(1);
		 }



/*
*   For each element in the current package, check to see if it's a 
*   widget type.  If so, create the widget(s).  Then, for all elements,
*   find out what window they're supposed to be mapped into, and build
*   an event chain.
*/
		ele = pck->element;
		while(ele != 0)
		{

			if(strlen(ele->screen_name))
			{
				s = pck->window;
				while(strcmp(ele->screen_name, s->name) 
						!= MATCH)
			        {
					if((s = s->next) == 0)
					{
					      printf("%s: can't match screen: %s in element %s\n"
					           ,funcname, ele->screen_name
						   , ele->name);
					      exit(1);
					  }
				  }
	      			ele->w = s->w;

			 }
			if(ele->type == TK_WIDGET || ele->type == TEXT)
			{
				m = ele->map;
				while(m != 0)
				{
				        if(m->simple.type > Unused_map)
					{
					    make_tk_widget(ele, m);
					    m = m->simple.next;
					 }
					else free((char *)m); 
				 }
			}

			if(timed_dimensions)
			{
printf("%s: timed_dims `%d'\n",funcname,timed_dimensions);
				make_event_chain_for( ele, timed_dimensions );
			 }
			ele = ele->next;    
  
  		}

	pck = pck->next;
	 
	}

}




Window
findparent(i, name, child)
 int i;
 char *name, *child;
{
  char *funcname = "findparent";
  Screen *s;
  
  s = screen_sets[i];
  while (s != 0){
    	if(strcmp(name, s->name))
    	{
      		s = s->next;
    	 }
    	else
	{
      		if (s->w) 
		{
			return(s->w);
		 }
      		else
		{
            		printf("%s: can't create child %s before parent %s\n",
		     	    funcname,child,name);
	    		exit(1);
	  	 }
    	 }
   }
 
  printf("%s: can't find window named %s in this set.\n",funcname,name);
  exit(1);    
}



int
makewindows()
{
char *funcname = "makewindows";
Screen *s;
OpaqueFrame frame;
int i, x;

for(i=0;(s = screen_sets[i]);++i)
{
  while(s != 0)
  {
    switch(s->type)
    {


    case WINDOW:
      s->w = XCreateWindow(
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );


      if (s->w == 0) {
	printf("%s: can't open opaque window\n", funcname);
	exit(1);
      }
printf("%s: mapping window `%s', id `%d'\n",funcname,s->name,s->w);

      XMapWindow(s->w);
      break;

    case TRANSPARENCY:
      printf("making transparent window named %s\n",s->name);

      s->w = XCreateTransparency(
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
			   s->x,
			   s->y,
			   s->width,
			   s->height  );

        if (s->w == 0) {
	  printf("%s: can't open transparent window\n", funcname);
	  exit(1);
	}
        XMapWindow(s->w);

       break;

    case VIDEO:


      s->w = XCreateVideoWindow (
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }
printf("made video window named %s,  id `%d'\n",s->name, s->w);

        XMapWindow(s->w);
        XStartVideo(s->w,0,0,PRIO_2);
        break;

    case STILL:
printf("making still video named %s\n",s->name);

      s->w = XCreateVideoWindow (
		    strcmp(s->parentname, "RootWindow") ? 
			   (Window)findparent(i,s->parentname, s->name) :
			   RootWindow, 
	            s->x, 
	            s->y, 
	            s->width, 
	            s->height,
	            s->borderwidth,
		    s->border_pixmap,
		    s->background_pixmap
		   );

      if (s->w == 0) {
	printf("%s: can't open video window\n", funcname);
	exit(1);
      }

      break;
    default:
      break;
  }

  s = s->next;
  }
}
  XFlush();
}
