#include <stdio.h>
#include <X10/Xlib.h>

#define VideoWidth      640
#define VideoHeight     482

#define VIDBACK 0
#define FAILURE 0
#define FALSE 1

main()

{
Window          mapwindow;
char            geom[32];
Pixmap          p;
OpaqueFrame     frame;
int             i;
Font            f;
char            msg[32];

        if(XOpenDisplay(NULL) == NULL ) {
                printf("unable to open display\n");
                exit(1);
                }

        frame.bdrwidth = 0;   /* was 16 */
        frame.border = XMakeTile(BlackPixel);
        frame.background = XMakeTile(VIDBACK);

        sprintf(geom,"%dx%d+0+0", VideoWidth,VideoHeight );

        mapwindow = XCreateVideo (
                "Video Map",
                "tpmap",
                geom,
                geom,
                &frame,
                64,48);
        if (mapwindow == FAILURE) {
                fprintf(stderr,"can't open map window\n");
                exit(1);
                }

        f = XGetFont("timrom12");
        if( f==0 ) {
                printf("can't open font\n");
                exit(1);
                }

        XMapWindow(mapwindow);
        XSync(FALSE);

        XStillVideo( mapwindow, 0,0,0,0,VideoWidth,VideoHeight);
        XSync(FALSE);


        /* note that the color MUST be ODD */

        XSetVideoColor(3,0xff,0,0);     /* red */
        XSetVideoColor(5,0,0xff,0);     /* green */
        XSetVideoColor(7,0,0,0xff);   /* blue */
        XSetVideoColor(9,0xff,0xff,0xff);       /* white */

        XLine(mapwindow,0,0,100,100,2,2,3,GXcopy,0x3f);
        XLine(mapwindow,100,100,200,200,2,2,5,GXcopy,0x3f);
        XLine(mapwindow,200,200,300,300,2,2,7,GXcopy,0x3f);

        XPixFill(mapwindow, 100,300,100,100, 3, 0,GXcopy,0x3f); /* red box */

        strcpy(msg,"Hi");
        XTextPad(mapwindow, 110,310,msg,strlen(msg),f,0,0,9,3,GXcopy,0x3f);

        XSetVideoColor(3,0xff,0,0);     /* red */
        XSetVideoColor(5,0,0xff,0);     /* green */
        XSetVideoColor(7,0,0,0xff);   /* blue */
        XSetVideoColor(9,0xff,0xff,0xff);       /* white */

        XFlush();
        while(1);

}

