
#include <stdio.h>
#include "videomap.h"

char *calloc();
char *malloc();

main(argc,argv)

	int argc;
	char **argv;
{
VideoMapPtr vmp;
char fn[64];
char nbuf[12];
int num;

	if( argc > 1 ) strcpy(fn,argv[1]);
	else {
		printf("what map file ? ");
		gets( fn );
		}

	if( argc > 2 ) num = atoi(argv[2]);
	else {
		printf("what number to fetch ? ");
		gets(nbuf);
		num = atoi(nbuf);
		}

	vmp = GetVideoMap( fn, num );

	if( vmp == NULL ) exit(1);
	printf("TEST: \n");
	printf("name: <%s>\n",vmp->name);
	printf("xtiles, ytiles: %dx%d\n",vmp->xtiles,vmp->ytiles);
	printf("xoverlap, yoverlap: %f,%f\n",vmp->xoverlap,vmp->yoverlap);
	printf("start, offset: %d,%d\n",vmp->start,vmp->offset);
}

#define MAXSTR 	255
#define FAIL	1
#define SUCCESS	0
#define RECLEN	7		/* lines of the map data record in file */

VideoMapPtr
GetVideoMap( mapfile, number )

	char *	mapfile;
	int	number;
{
static char *funcname = "GetVideoMap";
FILE *fp;
int found, success;
char line[MAXSTR];
int num;
VideoMap vm;		/* local copy */
VideoMapPtr vmp;	/* returned */
int i;

	found = success = 0;

	if( (fp = fopen( mapfile, "r" )) == NULL ) {
		printf("%s: can't open map file %s\n",mapfile);
		return NULL;
		}

	while( !feof(fp) && !found ) {
		fgets( line, MAXSTR, fp );
		if( line[0] == '#' ) continue;	/* comment line */
		else if( line[0] == '(' ) {		/* check the number */
			if( sscanf( line, "(%d)", &num )==1 && num==number ) {
				found = 1;
				if( vmapget( fp, &vm ) != SUCCESS  ) break;
				else { success = 1; break; }
				}
			/* otherwise, toss the map and keep going */
			else for( i=0; i<RECLEN && !feof(fp); i++ ) 
				fgets( line, MAXSTR, fp );
			}
		else {
			printf("%s: syntax error in file %s\n",
				funcname,mapfile);
			break;
			}
		}

	if( !found ) {
		printf("%s: map #%d not found in file %s\n",
			funcname,number,mapfile);
		return NULL;
		}
	else if( !success ) {
		printf("%s: error parsing file %s for map #%d\n",
			funcname,mapfile,number);
		return NULL;
		}
	else {
		vmp = (VideoMapPtr) malloc(sizeof(VideoMap));
		if( vmp==NULL ) {
			printf("%s: no memory to allocate map\n",
				funcname );
			return NULL;
			}
		else {
			memcpy( vmp, &vm, sizeof(VideoMap) );
			return vmp;
			}
		}
}

static int
vmapget( fp, vmp )

	FILE *		fp;
	VideoMapPtr	vmp;
{
int result;
int i;
char tname[MAXSTR];
char *s;

	if( fp==NULL ) return FAIL;
	if( fscanf(fp,"map.name: %s\n",tname) != 1 ) return FAIL;	
	s = (char *) calloc( 1, strlen(tname) + 1 );
	strcpy( s, tname );
	vmp->name = s;
	if( fscanf(fp,"map.xtiles: %d\n",&(vmp->xtiles)) != 1 ) return FAIL;
	if( fscanf(fp,"map.ytiles: %d\n",&(vmp->ytiles)) != 1 ) return FAIL;
	if( fscanf(fp,"map.xoverlap: %f\n",&(vmp->xoverlap)) != 1 ) return FAIL;
	if( fscanf(fp,"map.yoverlap: %f\n",&(vmp->yoverlap)) != 1 ) return FAIL;
	if( fscanf(fp,"map.start: %d\n",&(vmp->start)) != 1 ) return FAIL;
	if( fscanf(fp,"map.offset: %d\n",&(vmp->offset)) != 1 ) return FAIL;
	return SUCCESS;
}
