#include <X/Xlib.h>
#include <signal.h>
#include <sys/time.h>


Window windowid;
XEvent rp, *rep = &rp;
Font f;

int timer();
int tries = 0;


/********************************************************************
* MAIN
*
* 
*
*/
main()
{

int count = 0;
int len;
char *msg[30];

struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;


/*********************
* Initialize the timer 
*/

timvl.it_value.tv_sec = 1;
timvl.it_value.tv_usec = 0;
timvl.it_interval.tv_sec = 1;
timvl.it_interval.tv_usec = 0;




/*********************
*   Open the X display
*       For some reason, the signal alarm sent the thing back through
*       these parts on the first interrupt.  `Tries' is a fix to keep
*	it from trying to reinitialize the windows.
*/

if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }


/**********************
*  Create a root window
*/
if(tries == 1){  
  windowid = XCreateWindow(RootWindow,
			 50,
			 50,
			 400,
			 200,
			 3,
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(windowid);


/**********************
*  Set up the font.
*/

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }



/***********************
*  Select inputs to root
*/

  XSelectInput(windowid, ButtonPressed | ButtonReleased | KeyPressed);


/***************************
*  Start the timer interrupt.
*/

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();

}  /* this guy marks the end of the init stuff, protected by `tries' */






/************************************************************************
*   MAIN CONTROL loop starts here.
*
*    What this thing does is wait for an event from the user.  It 
*    finds out what kind of event it's got, then calls a jobber to
*    take care of it.
*/

while(1){



/********************************************
*  Get next event;  blocks if queue is empty.
*/
  XNextEvent(rep);

  switch (rep->type){
	CASE  ButtonPressed:
		d = XButtonPressedEvent->detail;
  		sprintf(msg,"Button Press %d",d);
  		len = strlen(msg);
  		XText(windowid,
			100,125,msg,len,f,BlackPixel,WhitePixel);
		break;

	CASE  ButtonReleased:
		d = XButtonReleasedEvent->detail;
  		sprintf(msg,"Button Release %d",d);
  		len = strlen(msg);
  		XText(windowid,
			100,135,msg,len,f,BlackPixel,WhitePixel);
		break;

	CASE  KeyPressed:
		d = XKeyPressedEvent->detail;
  		sprintf(msg,"Keycode %d",d);
  		len = strlen(msg);
  		XText(windowid,
			100,110,msg,len,f,BlackPixel,WhitePixel);
	
		break;

   }



  
 }

}/***********   END MAIN  **************************/



/************************************************************************
*   TIMER CONTROL LOOP
*      	This one fires up on every alarm.  Goes through the list of 
*	timed events, then goes back to sleep.
*/
int 
timer()
{
  static int count;
  char *msg[30];
  int len;

  ++count;
  sprintf(msg,"Timer%d",count);
  len = strlen(msg);

  XText(windowid,
	100,10,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
}

