
/* ev_glue.c */

#include <stdio.h>
#include <X10/Xlib.h>
#include "ev_tokens.h"
#include "Xtlib.h"
#include "XFuncs.h"

#define DOUBLE_TICKS	50		/* 1/2 second for DoubleClick */

extern OBJ_PTR	curobj;
extern ENV_PTR	curenv;
extern CODE_PTR	curcode;

/* --- absolute coords stuff --------- */

int
GetAbsoluteXY( parent, relX,relY, absX, absY )
	Window	parent;
	int	relX,relY;
	char *	absX;	/* returned */
	char *	absY;	/* returned */
{
int	x,y;
int	res;

	res = Get_Absolute_Coords( parent, relX, relY, &x, &y );
	sprintf(absX,"%d",x);
	sprintf(absY,"%d",y);
	return res;
}

/* --------- mouse stuff ----------- */

int
QueryMouse( w, xs, ys, subs )
	Window	w;
	char *xs;
	char *ys;
	char *subs;
{
int	x,y;
Window	sub;

	XQueryMouse( w, &x, &y, &sub );
	sprintf( xs, "%d", x );
	sprintf( ys, "%d", y );
	sprintf( subs, "%ld", sub );
	return 0;	
}
	
/* ------- colors stuff ------------ */

#define NCOLORS	32

static	int	PlaneMask;
static	Color	Colors[NCOLORS];
static	int	ColorUsed[NCOLORS];

int
InitColors()
{
int	i;
int	Pixels[NCOLORS];

	if( DisplayPlanes() < 2 )
	{
		printf("InitColors(): running on B&W display\n");
		return 0;
	}
	if( !XGetColorCells( 1, NCOLORS, 0, &PlaneMask, Pixels ) )
	{
		printf("XGetColorCells() failed!\n");
		return -1;
	}
	for( i=0; i<NCOLORS; i++ )
		Colors[i].pixel = Pixels[i];
	return 0;
}

int
FindColor( cname )
	char *cname;
{
int	i;
Color	cdef;

	if( DisplayPlanes() < 2 )
	{
		if( !strcmp(cname,"white") )
			return WhitePixel;
		else if( !strcmp(cname,"black") )
			return BlackPixel;
		else
			return BlackPixel;
	}

	XParseColor( cname, &cdef );

	for( i=NCOLORS-1; i>=0; --i )
	{
		if( ColorUsed[i] )
		{
			XQueryColor( &Colors[i] );
			if( 	Colors[i].red == cdef.red &&
				Colors[i].green == cdef.green &&
				Colors[i].blue == cdef.blue )
			{
				return Colors[i].pixel;
			}
		}
	}
	return -1;
}

int
GetColor( cname )
	char *cname;
{
int	i;
Color	cdef;
int	pel;

	pel = FindColor( cname );
	if( pel >= 0 )
		return pel;
	
	XParseColor( cname, &cdef );
	for( i=NCOLORS-1; i>=0; --i )
		if( !ColorUsed[i] )
			break;
	if( i<0 )
		return -1;
	ColorUsed[i] = 1;
	cdef.pixel = Colors[i].pixel;
	XStoreColor( &cdef );
	return cdef.pixel;
}

/* ------ eXcESs Glue ---------- */

char *
theObj()
{
	if( !curobj )
	{
		printf("theObj(): no current object!\n");
		return "";
	}
	return curobj->name;
}

int
theWindow()
{
	if( !curobj )
	{
		printf("theObj(): no current object!\n");
		return 0;
	}
	if( !curobj->binding )
	{
		printf("theObj(): no current window binding!\n");
		return 0;
	 }
	return curobj->binding->w;
}

char *
theEnv()
{
	if( !curenv )
	{
		printf("theEnv(): no current environment!\n");
		return "";
	}
	return curenv->name;
}

char *
theCode()
{
	if( !curcode )
	{
		printf("theCode(): no current code!\n");
		return "";
	}
	return curcode->name;
}

int
Quit()
{
	XFlush();
	exit(0);
}

/* --------------- X Glue ---------------------- */

int
MakeCursor( cursor_file, mask_file, fg_color, bg_color )
	char *cursor_file;
	char *mask_file;
	char *fg_color;
	char *bg_color;
{
short *mask_data;
short *cursor_data;
int	w,h, x_hot, y_hot;
Bitmap	mask, cursor;
Cursor	theCursor;
int	fg, bg;

	if( !XReadBitmapFile(mask_file,&w,&h,&mask_data,&x_hot,&y_hot) )
	{
		printf("MakeCursor(): unable to read mask file '%s'\n",mask_file);
		return 0;
	}
	mask = XStoreBitmap( w, h, mask_data );
	if( !XReadBitmapFile(cursor_file,&w,&h,&cursor_data,&x_hot,&y_hot) )
	{
		printf("MakeCursor(): unable to read cursor file '%s'\n",cursor_file);
		return 0;
	}
	cursor = XStoreBitmap( w, h, cursor_data );
	fg = GetColor( fg_color );
	if( fg < 0 )
		fg = BlackPixel;
	bg = GetColor( bg_color );
	if( bg < 0 )
		bg = WhitePixel;
	theCursor = XStoreCursor( cursor, mask, x_hot, y_hot, fg, bg, GXcopy );
	return theCursor;
}

int
QueryWindow( window, w,h,x,y, bdr, mapped, type, assoc )
	Window	window;
	char 	*w, *h, *x, *y, *bdr, *mapped, *type, *assoc;	/* all returned */
{
WindowInfo	wi;
char *		mapstr;
char *		typestr;

	if( !XQueryWindow( window, &wi ) )
	{
		printf("unable to QueryWindow() on window id #%ld\n",window);
		return 0;	/* failure */
	}
	sprintf(w,"%d",wi.width);
	sprintf(h,"%d",wi.height);
	sprintf(x,"%d",wi.x);
	sprintf(y,"%d",wi.y);
	sprintf(bdr,"%d",wi.bdrwidth);
	switch( wi.mapped )
	{
	case IsUnmapped:
		mapstr = "Unmapped";
		break;
	case IsMapped:
		mapstr = "Mapped";
		break;
	case IsInvisible:
		mapstr = "Invisible";
		break;
	default:
		mapstr = "";
		break;
	}
	strcpy(mapped,mapstr);
	switch( wi.type )
	{
	case IsTransparent:
		typestr = "Transparent";
		break;
	case IsOpaque:
		typestr = "Opaque";
		break;
	case IsIcon:
		typestr = "Icon";
		break;
	default:
		typestr = "";
		break;
	}
	strcpy(type,typestr);
	sprintf(assoc,"%ld",wi.assoc_wind);
	return 1;	/* success */
}

int
QueryHeight( f )
	Font	f;
{
FontInfo	fi;

	if( !XQueryFont( f, &fi ) )
		return 0;
	return fi.height;
}

int
GXCOPY()
{
	return GXcopy;
}

int
ALLPLANES()
{
	return AllPlanes;
}

int
IconSwitch( w )
	Window w;
{
	IconXlate( w );
}

int
myWindow()
{
	return curobj->binding->w;
}

int
GetAFont( name )
	char *name;
{
	return XGetFont( name );
}

int
ShowText( w, x, y, str, len, font, foreground )
	int	w,x,y;
	char *	str;
	int	len,font,foreground;
{
	XTextMask( (Window)w, x, y, str, len, (Font)font, foreground );
}

int
Beep()
{
	XFeep(0);
}

int
FlushEvents()
{
	XFlush();
}

int
theRoot()
{
	return RootWindow;
}

int
WhitePM()
{
	return WhitePixmap;
}

int
BlackPM()
{
	return BlackPixmap;
}

int
MakeWindow( parent, x,y,w,h,bw, border, bgnd )
	int parent;
	int x,y,w,h,bw;
	Pixmap border,bgnd;
{
	return XCreateWindow( (Window)parent,x,y,w,h,bw,(Pixmap)border,(Pixmap)bgnd );
}

int
MapWindow( w )
	Window w;
{
	XMapWindow( w );
}

int
MapChildren( w )
	Window w;
{
	XMapSubwindows( w );
}

int
UnMap( w )
	Window w;
{
	XUnmapWindow( w );
}

int
MoveWindow( w, x, y )
	int	w,x,y;
{
	XMoveWindow( w, x, y );
}

int
ChangeWindow( w, wid, h)
	int	w, wid, h;
{
	XChangeWindow( w, wid, h );
}

int
ClearWindow( w )
	Window w;
{
	XClear( (Window)w );
}

int
SetIconWindow( w, iw )
	Window w, iw;
{
	XSetIconWindow( w, iw );
}

int
WarpMouse( w,x,y )
        Window w;
        int x,y;
{
        XWarpMouse(w,x,y);
}


int
MakeBitmap( file, width, height )
	char *file;
	char *width;	/* returned */
	char *height;	/* returned */
{
short *data;
int	w,h, x_hot, y_hot;
Bitmap	b;

	if( !XReadBitmapFile(file,&w,&h,&data,&x_hot,&y_hot) )
	{
		printf("MakeBitmap(): unable to read file '%s'\n",file);
		return 0;
	}
	b = XStoreBitmap( data, w, h );
	sprintf(width,"%d",w);
	sprintf(height,"%d",h);
	return b;
}

int
MakePixmap( file, fg_color, bg_color, width, height )
	char *file;
	char *fg_color;
	char *bg_color;
	char *width;	/* returned, in string */
	char *height;	/* returned, in string */
{
short *data;
int	w,h, x_hot, y_hot;
Bitmap	b;
Pixmap	p;
Color	cdef;
int	fg, bg;

	if( XReadBitmapFile(file,&w,&h,&data,&x_hot,&y_hot) )
	{
		fg = GetColor( fg_color );
		bg = GetColor( bg_color );
		if( fg < 0 )
			fg = BlackPixel;
		if( bg < 0 )
			bg = WhitePixel;
		b = XStoreBitmap( w,h, data );
		p = XMakePixmap( b, fg, bg );
		sprintf(width,"%d",w);
		sprintf(height,"%d",h);
		return (int)p;
	}
	return 0;
}


/* -----  Window binding and Xevent glue for XScript -------------- */

int
RegisterWindow( w, name )

	Window w;
	char *name;
{
HashNodePtr	hnp;
OBJ_PTR		op;
WBIND_PTR	wbp;
CODE_PTR	cp;
int		mask = 0;

	if( !curenv || !name )
		return -1;
	if( curenv->wb_table == NULL )
		curenv->wb_table = XCreateAssocTable( 64 );
	op = findobj(curenv,name);
	if( !op )
	{
		printf("object '%s' not found in env\n",name);
		return -1;
	}
	wbp = op->binding;
	wbp->w = w;
	XMakeAssoc( curenv->wb_table, w, (char *) wbp );
	/* select appropriate X inputs */
	for( cp=op->codelist; cp; cp=cp->next )
	{
		if( cp->type == MSG_CODESEG )
		{
			if( !strcmp(cp->name,"KeyPressed") )
				mask |= KeyPressed;
			else if( !strcmp(cp->name,"KeyReleased") )
				mask |= KeyReleased;
			else if( !strcmp(cp->name,"ButtonPressed") )
				mask |= ButtonPressed;
			else if( !strcmp(cp->name,"ButtonReleased") )
				mask |= ButtonReleased;
			else if( !strcmp(cp->name,"EnterWindow") )
				mask |= EnterWindow;
			else if( !strcmp(cp->name,"LeaveWindow") )
				mask |= LeaveWindow;
			else if( !strcmp(cp->name,"MouseMoved") )
				mask |= MouseMoved;
			else if( !strcmp(cp->name,"ExposeWindow") )
				mask |= ExposeWindow;
			else if( !strcmp(cp->name,"ExposeRegion") )
				mask |= ExposeRegion;
			else if( !strcmp(cp->name,"ExposeCopy") )
				mask |= ExposeCopy;
			else if( !strcmp(cp->name,"RightDownMotion") )
				mask |= RightDownMotion;
			else if( !strcmp(cp->name,"MiddleDownMotion") )
				mask |= MiddleDownMotion;
			else if( !strcmp(cp->name,"LeftDownMotion") )
				mask |= LeftDownMotion;
			else if( !strcmp(cp->name,"UnmapWindow") )
				mask |= UnmapWindow;
			else if( !strcmp(cp->name,"FocusChange") )
				mask |= FocusChange;

			/* additional manufactured events/messages */
			else if( !strcmp(cp->name,"DoubleClick") )
				mask |= ButtonReleased;
		}
	}
	XSelectInput( w, mask );
	return 0;
}

int
handle_msgs( ep )

	XEvent *ep;
{
WBIND_PTR	wbp;
char *		kstr;
char		temp[MAXSTR];
int		nbytes;
int		button;
int		detail;
int		mask;
char		msg[MAXSTR];
unsigned short	last_up = NULL;		/* time of last mouse_up event */
Window		last_up_win = NULL;	/* last mouse_up window */
int		last_up_button = NULL;
XKeyOrButtonEvent *korb_evp;
XMouseOrCrossingEvent *morc_evp;
XExposeEvent *exp_evp;
XExposeCopyEvent *expc_evp;
XUnmapEvent *um_evp;
XFocusChangeEvent *fc_evp;

	if( !curenv || !curenv->wb_table )
		return 0;

	wbp = (WBIND_PTR) XLookUpAssoc( curenv->wb_table, ep->window );
	if( !wbp )
		return 0;

	switch( ep->type )
	{
		case KeyPressed:	/* "KeyPressed <keystr>" */
			korb_evp = (XKeyOrButtonEvent *) ep;
			kstr = XLookupMapping( korb_evp, &nbytes );
			strncpy( temp, kstr, nbytes );
			sprintf(msg,"KeyPressed `%s`",temp);
			ev_SendMsg( wbp->wname, msg );
			break;
		case KeyReleased:	/* "KeyReleased <keystr>" */
			korb_evp = (XKeyOrButtonEvent *) ep;
			kstr = XLookupMapping( korb_evp, &nbytes );
			strncpy( temp, kstr, nbytes );
			sprintf(msg,"KeyReleased `%s`",temp);
			ev_SendMsg( wbp->wname, msg );
			break;
		case ButtonPressed:	/* "ButtonPressed <which> <x> <y> <keymask>" */
			korb_evp = (XKeyOrButtonEvent *) ep;
			button = (korb_evp->detail & 0x00ff);
			if( button == RightButton )
				strcpy( temp, "Right" );
			else if( button == MiddleButton )
				strcpy( temp, "Middle" );
			else if( button == LeftButton )
				strcpy( temp, "Left" );
			mask = (korb_evp->detail & 0xff00);
			sprintf(msg,"ButtonPressed %s %d %d %d",temp,
				korb_evp->x,korb_evp->y,mask);
			ev_SendMsg( wbp->wname, msg );
			break;
		case ButtonReleased:	/* "ButtonReleased <which> <x> <y> <keymask>" */
			korb_evp = (XKeyOrButtonEvent *) ep;
			button = (korb_evp->detail & 0x00ff);
			if( button == RightButton )
				strcpy( temp, "Right" );
			else if( button == MiddleButton )
				strcpy( temp, "Middle" );
			else if( button == LeftButton )
				strcpy( temp, "Left" );
			mask = (korb_evp->detail & 0xff00);
			if( last_up_win == korb_evp->window 
				&& (korb_evp->time-last_up) < DOUBLE_TICKS 
				&& button == last_up_button )
			{
				sprintf(msg,"DoubleClick %s %d %d %d",temp,
					korb_evp->x,korb_evp->y,mask);
				last_up = 0;
				last_up_win = (Window)0;
				last_up_button = 0;
			}
			else
			{
				last_up = korb_evp->time;
				last_up_win = korb_evp->window;
				last_up_button = button;
				sprintf(msg,"ButtonReleased %s %d %d %d",temp,
					korb_evp->x,korb_evp->y,mask);
			}
			ev_SendMsg( wbp->wname, msg );
			break;
		case EnterWindow:	/* "EnterWindow <From/To code> <subwindow>" */
			morc_evp = (XMouseOrCrossingEvent *) ep;
			detail = (morc_evp->detail & 0x00ff);
			sprintf(msg,"EnterWindow %d %ld",detail,morc_evp->subwindow);
			ev_SendMsg( wbp->wname, msg );
			break;
		case LeaveWindow:	/* "LeaveWindow <From/To code> <subwindow>" */
			morc_evp = (XMouseOrCrossingEvent *) ep;
			detail = (morc_evp->detail & 0x00ff);
			sprintf(msg,"LeaveWindow %d %ld",detail,morc_evp->subwindow);
			ev_SendMsg( wbp->wname, msg );
			break;
		case MouseMoved:	/* "MouseMoved <x> <y>" */
			morc_evp = (XMouseOrCrossingEvent *) ep;
			sprintf( msg, "MouseMoved %d %d", morc_evp->x, morc_evp->y );
			ev_SendMsg( wbp->wname, msg );
			break;
		case LeftDownMotion:	/* "LeftDownMotion <x> <y>" */
			morc_evp = (XMouseOrCrossingEvent *) ep;
			sprintf( msg, "LeftDownMotion %d %d", morc_evp->x, morc_evp->y );
			ev_SendMsg( wbp->wname, msg );
			break;
		case MiddleDownMotion:	/* "MiddleDownMotion <x> <y>" */
			morc_evp = (XMouseOrCrossingEvent *) ep;
			sprintf( msg, "MiddleDownMotion %d %d", morc_evp->x, morc_evp->y );
			ev_SendMsg( wbp->wname, msg );
			break;
		case RightDownMotion:	/* "RightDownMotion <x> <y>" */
			morc_evp = (XMouseOrCrossingEvent *) ep;
			sprintf( msg, "RightDownMotion %d %d", morc_evp->x, morc_evp->y );
			ev_SendMsg( wbp->wname, msg );
			break;
		case ExposeWindow:	/* "ExposeWindow <subwindow>" */
			exp_evp = (XExposeEvent *) ep;
			sprintf( msg, "ExposeWindow %ld", exp_evp->subwindow );
			ev_SendMsg( wbp->wname, msg );
			break;
		case ExposeRegion:	/* "ExposeRegion <x> <y> <w> <h> <subwindow>" */
			exp_evp = (XExposeEvent *) ep;
			sprintf( msg, "ExposeRegion %d %d %d %d %ld", 
				exp_evp->x,exp_evp->y,
				exp_evp->width,exp_evp->height,
				exp_evp->subwindow );
			ev_SendMsg( wbp->wname, msg );
			break;
		case ExposeCopy:	/* "ExposeCopy <subwindow>" */
			expc_evp = (XExposeCopyEvent *) ep;
			sprintf(msg,"ExposeCopy %ld", expc_evp->subwindow );
			ev_SendMsg( wbp->wname, msg );
			break;
		case UnmapWindow:	/* "UnmapWindow <subwindow>" */
			um_evp = (XUnmapEvent *) ep;
			sprintf( msg, "UnmapWindow %ld", um_evp->subwindow );
			ev_SendMsg( wbp->wname, msg );
			break;
		case FocusChange:	/* "FocusChange <subwindow>" */
			fc_evp = (XFocusChangeEvent *) ep;
			if( fc_evp->detail == EnterWindow )
				strcpy( temp, "EnterWindow" );
			else if( fc_evp->detail == LeaveWindow )
				strcpy( temp, "LeaveWindow" );
			sprintf( msg, "FocusChange %s %ld", temp,fc_evp->subwindow );
			ev_SendMsg( wbp->wname, msg );
			break;
		default:
			break;	
	}
	return 0;
}

int
InitErrorHandler()
{
int	ev_XErrorHandler();

	XErrorHandler( ev_XErrorHandler );
}

int
ev_XErrorHandler( dp, evp )
	Display *dp;
	XErrorEvent *evp;
{
char *XFuncName();
WBIND_PTR wbp;

	printf("\n");
	printf(">>> X-Windows ERROR encountered:\n");
	printf(">>> \t%s\n",XErrDescrip(evp->error_code));
	printf(">>> \tX_Function: %s\n",XFuncName(evp->request_code));

	if( !curenv || !curenv->wb_table || 
		!(wbp = (WBIND_PTR) XLookUpAssoc( curenv->wb_table, evp->window )) )
		printf(">>> \tWindow ID: %ld\n",evp->window);
	else
		printf(">>> \tXS Window: '%s'\n",wbp->wname);

	if( curenv )
		printf(">>> \tin Environment: '%s'\n",curenv->name);	
	if( curobj )
		printf(">>> \tin Object: '%s'\n",curobj->name);	
	if( curcode )
		printf(">>> \tin Code Segment: '%s'\n",curcode->name);	

	printf("\n");
}

char *
XFuncName( code )
	int code;
{
int	 i;

	for( i=0; i<NumXFuncs; i++ )
		if( XFuncs[i].code == code )
			return XFuncs[i].name;
	return "";
}
